/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.storage.crate;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import pl.asie.charset.lib.render.IRenderComparable;
import pl.asie.charset.lib.utils.RenderUtils;

public class CrateCacheInfo
implements IRenderComparable<CrateCacheInfo> {
    public final ItemStack plank;
    public final int connectionMap;
    private final int hash;

    public CrateCacheInfo(ItemStack plank, int connectionMap) {
        this.plank = plank;
        this.connectionMap = connectionMap;
        int hash = 0;
        if (plank != null) {
            hash = hash * 3 + Item.func_150891_b((Item)plank.func_77973_b()) * 7 + plank.func_77960_j();
        }
        this.hash = hash = hash * 3 + connectionMap;
    }

    public boolean isConnected(EnumFacing side) {
        return (this.connectionMap & 1 << side.ordinal()) != 0;
    }

    public boolean isCorner(int x, int y, int z) {
        return (this.connectionMap & 1 << 6 + x * 4 + y * 2 + z) != 0;
    }

    public boolean isCorner(int c) {
        return (this.connectionMap & 1 << 6 + c) != 0;
    }

    public boolean equals(Object other) {
        return other instanceof CrateCacheInfo ? this.renderEquals((CrateCacheInfo)other) : false;
    }

    @Override
    public boolean renderEquals(CrateCacheInfo other) {
        return other.connectionMap == this.connectionMap && RenderUtils.getSprite(this.plank) == RenderUtils.getSprite(other.plank);
    }

    public int hashCode() {
        return this.hash;
    }

    @Override
    public int renderHashCode() {
        return this.hash;
    }
}

