/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.storage.crate;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import pl.asie.charset.lib.ModCharsetLib;
import pl.asie.charset.lib.blocks.BlockBase;
import pl.asie.charset.lib.utils.GenericExtendedProperty;
import pl.asie.charset.storage.crate.CrateCacheInfo;
import pl.asie.charset.storage.crate.CrateRegistry;
import pl.asie.charset.storage.crate.TileEntityCrate;

public class BlockCrate
extends BlockBase
implements ITileEntityProvider {
    public static final boolean SHOW_ALL_CRATES = false;
    public static final GenericExtendedProperty<CrateCacheInfo> PROPERTY = new GenericExtendedProperty<CrateCacheInfo>("cache", CrateCacheInfo.class);
    ArrayList<ItemStack> todaysCrates = null;

    public BlockCrate() {
        super(Material.field_151575_d);
        this.func_149647_a(ModCharsetLib.CREATIVE_TAB);
        this.func_149663_c("charset.crate");
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityCrate) {
            return ((TileEntityCrate)tile).getFlamability();
        }
        return 0;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityCrate) {
            ((TileEntityCrate)tile).neighborChanged(block);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IUnlistedProperty[]{PROPERTY}).build();
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityCrate) {
            return ((IExtendedBlockState)state).withProperty(PROPERTY, (Object)((TileEntityCrate)tile).getCacheInfo());
        }
        return state;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityCrate();
    }

    public void func_149666_a(Item me, CreativeTabs tab, List<ItemStack> itemList) {
        if (this.todaysCrates == null) {
            this.todaysCrates = new ArrayList();
            Calendar cal = (Calendar)ModCharsetLib.calendar.get();
            int doy = cal.get(6) - 1;
            ArrayList<ItemStack> weeklyCrates = new ArrayList<ItemStack>();
            weeklyCrates.addAll(CrateRegistry.INSTANCE.getCrates());
            Collections.shuffle(weeklyCrates, new Random(doy));
            int cratesToAdd = 1;
            for (ItemStack crate : weeklyCrates) {
                this.todaysCrates.add(crate);
                if (--cratesToAdd > 0) continue;
                break;
            }
        }
        itemList.addAll(this.todaysCrates);
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }
}

