/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.storage.barrel;

import java.util.Calendar;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.ForgeHooksClient;
import pl.asie.charset.lib.ModCharsetLib;
import pl.asie.charset.lib.factorization.FzOrientation;
import pl.asie.charset.lib.factorization.Quaternion;
import pl.asie.charset.lib.factorization.SpaceUtil;
import pl.asie.charset.lib.render.ModelTransformer;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.storage.ModCharsetStorage;
import pl.asie.charset.storage.barrel.BarrelModel;
import pl.asie.charset.storage.barrel.TileEntityDayBarrel;

public class TileEntityDayBarrelRenderer
extends TileEntitySpecialRenderer<TileEntityDayBarrel> {
    final String[] fontIdx = new String[]{"0123", "4567", "89*+", "i! c"};
    private static final ResourceLocation RES_ITEM_GLINT = new ResourceLocation("textures/misc/enchanted_item_glint.png");

    void doDraw(TileEntityDayBarrel barrel, ItemStack is, float partialTicks) {
        double time;
        FzOrientation bo = barrel.orientation;
        EnumFacing face = bo.facing;
        if (SpaceUtil.sign(face) == 1) {
            GlStateManager.func_179109_b((float)face.func_176730_m().func_177958_n(), (float)face.func_176730_m().func_177956_o(), (float)face.func_176730_m().func_177952_p());
        }
        GlStateManager.func_179137_b((double)(0.5 * (double)(1 - Math.abs(face.func_176730_m().func_177958_n()))), (double)(0.5 * (double)(1 - Math.abs(face.func_176730_m().func_177956_o()))), (double)(0.5 * (double)(1 - Math.abs(face.func_176730_m().func_177952_p()))));
        Quaternion quat = Quaternion.fromOrientation(bo.getSwapped());
        quat.glRotate();
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)0.25, (double)0.1875, (double)-0.0078125);
        if (barrel.type.isHopping() && Math.sin((time = (double)((float)barrel.func_145831_w().func_82737_E() + partialTicks)) / 22.5) > 0.0) {
            double delta = Math.max(0.0, Math.sin(time / 2.25) / 16.0);
            GlStateManager.func_179137_b((double)0.0, (double)delta, (double)0.0);
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179145_e();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean hasLabel = this.renderItemCount(is, barrel);
        this.handleRenderItem(is, barrel, hasLabel);
    }

    public void renderTileEntityAt(TileEntityDayBarrel barrel, double x, double y, double z, float partialTicks, int destroyStage) {
        if (barrel == null) {
            return;
        }
        ItemStack is = barrel.item;
        if (is == null || barrel.getItemCount() <= 0) {
            return;
        }
        EnumFacing facing = barrel.orientation.facing;
        BlockPos facingPos = barrel.func_174877_v().func_177972_a(facing);
        if (barrel.func_145831_w().isSideSolid(facingPos, facing.func_176734_d())) {
            return;
        }
        Minecraft.func_71410_x().field_71424_I.func_76320_a("barrel");
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
        int l = barrel.func_145831_w().func_175626_b(facingPos, barrel.func_145831_w().func_175657_ab());
        int j = l % 65536;
        int k = l / 65536;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)j / 1.0f), (float)((float)k / 1.0f));
        this.doDraw(barrel, is, partialTicks);
        GlStateManager.func_179121_F();
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
        GlStateManager.func_179084_k();
        RenderHelper.func_74519_b();
    }

    String getCountLabel(ItemStack item, TileEntityDayBarrel barrel) {
        IBlockState state;
        Calendar cal;
        if (barrel.type == TileEntityDayBarrel.Type.CREATIVE) {
            return "i";
        }
        int ms = item.func_77976_d();
        int count = barrel.getItemCount();
        if (count == 1) {
            return "";
        }
        String t = "";
        if (ms == 1 || count == ms) {
            t = t + count;
        } else {
            int r;
            int q = count / ms;
            if (q > 0) {
                t = t + count / ms + "*" + ms;
            }
            if ((r = count % ms) != 0) {
                if (q > 0) {
                    t = t + "+";
                }
                t = t + r;
            }
        }
        if (barrel.canLose()) {
            t = "!" + t + "!";
        }
        if ((cal = (Calendar)ModCharsetLib.calendar.get()).get(2) == 8 && cal.get(5) == 9 && (state = ItemUtils.getBlockState(item)) != null && (state.func_185904_a() == Material.field_151588_w || state.func_185904_a() == Material.field_151598_x)) {
            if (t.startsWith("9")) {
                t = "c" + t.substring(1);
            }
            if (t.endsWith("9")) {
                t = t.substring(0, t.length() - 1) + "c";
            }
        }
        return t;
    }

    boolean renderItemCount(ItemStack item, TileEntityDayBarrel barrel) {
        if (!ModCharsetStorage.renderBarrelText) {
            return false;
        }
        String t = this.getCountLabel(item, barrel);
        if (t.isEmpty()) {
            return false;
        }
        this.func_147499_a(TextureMap.field_110575_b);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        TextureAtlasSprite font = BarrelModel.font;
        int len = t.length();
        double char_width = 0.1;
        double char_height = 0.1;
        Tessellator tessI = Tessellator.func_178181_a();
        VertexBuffer tess = tessI.func_178180_c();
        tess.func_178969_c(-0.1 * (double)len / 2.0 + 0.25, -0.13125, 0.0);
        tess.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        double du = (font.func_94212_f() - font.func_94209_e()) / 4.0f;
        double dv = (font.func_94210_h() - font.func_94206_g()) / 4.0f;
        double u = font.func_94209_e();
        double v = font.func_94206_g();
        for (int i = 0; i < len; ++i) {
            char c = t.charAt(i);
            int x = 0;
            int y = 0;
            boolean found = false;
            block1: for (y = 0; y < this.fontIdx.length; ++y) {
                String idx = this.fontIdx[y];
                for (x = 0; x < idx.length(); ++x) {
                    if (c != idx.charAt(x)) continue;
                    found = true;
                    break block1;
                }
            }
            if (!found) continue;
            double IX = (double)i * 0.1;
            double dy = 0.99609375;
            tess.func_181662_b(IX + 0.1, 0.0, 0.0).func_187315_a(u + (double)(x + 1) * du, v + (double)y * dv).func_181675_d();
            tess.func_181662_b(IX, 0.0, 0.0).func_187315_a(u + (double)x * du, v + (double)y * dv).func_181675_d();
            tess.func_181662_b(IX, 0.1, 0.0).func_187315_a(u + (double)x * du, v + ((double)y + 0.99609375) * dv).func_181675_d();
            tess.func_181662_b(IX + 0.1, 0.1, 0.0).func_187315_a(u + (double)(x + 1) * du, v + ((double)y + 0.99609375) * dv).func_181675_d();
        }
        tessI.func_78381_a();
        tess.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179145_e();
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        return true;
    }

    public void handleRenderItem(ItemStack is, TileEntityDayBarrel barrel, boolean hasLabel) {
        if (!ModCharsetStorage.renderBarrelItem) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        float labelD = hasLabel ? 0.0f : -0.0625f;
        GlStateManager.func_179137_b((double)0.25, (double)(-0.25 - (double)labelD), (double)0.0);
        if (ModCharsetStorage.renderBarrelItem3D) {
            boolean isBlock = Minecraft.func_71410_x().func_175599_af().func_184393_a(is, null, null).func_177556_c();
            boolean isFullBlock = false;
            Block block = Block.func_149634_a((Item)is.func_77973_b());
            if (block != null) {
                isFullBlock = block.func_176223_P().func_185917_h();
            }
            if (isBlock) {
                GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.75f);
                if (isFullBlock) {
                    GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.1);
                }
            } else {
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            }
            RenderHelper.func_74519_b();
            Minecraft.func_71410_x().func_175599_af().func_181564_a(is, ItemCameraTransforms.TransformType.FIXED);
        } else {
            this.func_147499_a(TextureMap.field_110575_b);
            Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
            GlStateManager.func_179091_B();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179094_E();
            RenderHelper.func_74519_b();
            GlStateManager.func_179121_F();
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.02f);
            IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(is, null, null);
            model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
            if (model.func_177556_c() && !model.func_188618_c()) {
                model = ModelTransformer.transform(model, null, 0L, new ModelTransformer.IVertexTransformer(){

                    @Override
                    public float[] transform(BakedQuad quad, VertexFormatElement element, float ... data) {
                        if (element.func_177375_c() == VertexFormatElement.EnumUsage.NORMAL) {
                            data[0] = data[0] / 1.5f;
                            data[2] = data[2] * 1.7f;
                        }
                        return data;
                    }
                });
            }
            Minecraft.func_71410_x().func_175599_af().func_180454_a(is, model);
            GlStateManager.func_179101_C();
            Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        }
        GlStateManager.func_179121_F();
    }
}

