/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.storage.barrel;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import pl.asie.charset.lib.material.ColorLookupHandler;
import pl.asie.charset.lib.render.ModelColorizer;
import pl.asie.charset.lib.render.ModelFactory;
import pl.asie.charset.lib.render.WrappedBakedModel;
import pl.asie.charset.lib.utils.RenderUtils;
import pl.asie.charset.storage.barrel.BarrelCacheInfo;
import pl.asie.charset.storage.barrel.BlockBarrel;
import pl.asie.charset.storage.barrel.TileEntityDayBarrel;

public class BarrelModel
extends ModelFactory<BarrelCacheInfo> {
    public final ModelColorizer<BarrelCacheInfo> colorizer = new ModelColorizer<BarrelCacheInfo>((ModelFactory)this){

        @Override
        public int colorMultiplier(BarrelCacheInfo info, int tintIndex) {
            if (!info.isMetal && !info.type.isHopping()) {
                return ColorLookupHandler.INSTANCE.getColor(info.logStack, RenderUtils.AveragingMode.V_EDGES_ONLY);
            }
            return -1;
        }
    };
    public static final Map<String, BarrelGroup> TEXTURE_MAP = new HashMap<String, BarrelGroup>();
    public static TextureAtlasSprite font;
    public static IRetexturableModel template;

    public BarrelModel() {
        super(BlockBarrel.BARREL_INFO, TextureMap.field_174945_f);
        this.addDefaultBlockTransforms();
    }

    public static void onTextureLoad(TextureMap map) {
        TEXTURE_MAP.clear();
        new BarrelGroup("hopping", map);
        new BarrelGroup("sticky", map);
        new BarrelGroup("silky", map);
        new BarrelGroup("normal", map);
        font = map.func_174942_a(new ResourceLocation("charsetstorage:blocks/barrel/font"));
    }

    private String getGroupName(TileEntityDayBarrel.Type type) {
        if (type.isHopping()) {
            return "hopping";
        }
        if (type == TileEntityDayBarrel.Type.SILKY) {
            return "silky";
        }
        if (type == TileEntityDayBarrel.Type.STICKY) {
            return "sticky";
        }
        return "normal";
    }

    @Override
    public IBakedModel bake(BarrelCacheInfo info, boolean isItem, BlockRenderLayer layer) {
        TextureAtlasSprite log = info.log;
        TextureAtlasSprite plank = info.plank;
        String groupName = this.getGroupName(info.type);
        BarrelGroup group = TEXTURE_MAP.get(groupName);
        TextureAtlasSprite top = info.isMetal ? group.top_metal : group.top;
        TextureAtlasSprite front = group.front;
        TextureAtlasSprite side = group.side;
        HashMap<String, String> textures = new HashMap<String, String>();
        HashMap<ResourceLocation, TextureAtlasSprite> map = new HashMap<ResourceLocation, TextureAtlasSprite>();
        if (isItem || layer == BlockRenderLayer.SOLID) {
            textures.put("log", log.func_94215_i());
            textures.put("plank", plank.func_94215_i());
        }
        if (isItem || layer == BlockRenderLayer.TRANSLUCENT) {
            textures.put("top", top.func_94215_i());
            textures.put("front", front.func_94215_i());
            textures.put("side", side.func_94215_i());
        }
        for (String s : new String[]{"log", "plank", "top", "front", "side"}) {
            if (textures.get(s) != null) continue;
            textures.put(s, "");
            textures.put("#" + s, "");
        }
        textures.put("particle", log.func_94215_i());
        map.put(new ResourceLocation(log.func_94215_i()), log);
        map.put(new ResourceLocation(plank.func_94215_i()), plank);
        map.put(new ResourceLocation(top.func_94215_i()), top);
        map.put(new ResourceLocation(front.func_94215_i()), front);
        map.put(new ResourceLocation(side.func_94215_i()), side);
        TRSRTransformation state = info.orientation.toTransformation();
        ImmutableMap textureMap = ImmutableMap.copyOf(textures);
        IModel retexture = template.retexture(textureMap);
        return new WrappedBakedModel(retexture.bake((IModelState)state, DefaultVertexFormats.field_176600_a, RenderUtils.textureGetter)).addDefaultBlockTransforms();
    }

    @Override
    public BarrelCacheInfo fromItemStack(ItemStack stack) {
        return BarrelCacheInfo.from(stack);
    }

    public static class BarrelGroup {
        public TextureAtlasSprite front;
        public TextureAtlasSprite top;
        public TextureAtlasSprite side;
        public TextureAtlasSprite top_metal;

        public BarrelGroup(String type, TextureMap map) {
            this.front = map.func_174942_a(new ResourceLocation("charsetstorage:blocks/barrel/" + type + "/front"));
            this.side = map.func_174942_a(new ResourceLocation("charsetstorage:blocks/barrel/" + type + "/side"));
            this.top = map.func_174942_a(new ResourceLocation("charsetstorage:blocks/barrel/" + type + "/top"));
            this.top_metal = map.func_174942_a(new ResourceLocation("charsetstorage:blocks/barrel/" + type + "/top_metal"));
            TEXTURE_MAP.put(type, this);
        }
    }
}

