/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.storage.backpack;

import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import pl.asie.charset.lib.blocks.TileBase;
import pl.asie.charset.lib.inventory.IInventoryOwner;
import pl.asie.charset.lib.inventory.InventorySimple;
import pl.asie.charset.storage.ModCharsetStorage;
import pl.asie.charset.storage.backpack.ContainerBackpack;

public class TileBackpack
extends TileBase
implements IInteractionObject,
IInventory,
IInventoryOwner {
    private IItemHandler handler = new InvWrapper((IInventory)this);
    private InventorySimple inventory = new InventorySimple(27, this);
    private int color = -1;

    public int getColor() {
        return this.color >= 0 ? this.color : 8409144;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.handler);
        }
        return null;
    }

    @Override
    public void onPlacedBy(EntityLivingBase placer, ItemStack stack) {
        if (stack.func_77942_o()) {
            this.readNBTData(stack.func_77978_p(), false);
        }
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerBackpack(this, playerInventory);
    }

    public String func_174875_k() {
        return null;
    }

    public void readFromItemStack(ItemStack stack) {
        this.readNBTData(stack.func_77978_p(), false);
    }

    public ItemStack writeToItemStack() {
        ItemStack stack = new ItemStack((Block)ModCharsetStorage.backpackBlock);
        stack.func_77982_d(new NBTTagCompound());
        this.writeNBTData(stack.func_77978_p(), false);
        return stack;
    }

    @Override
    public void readNBTData(NBTTagCompound nbt, boolean isClient) {
        int oldColor = this.color;
        int n = this.color = nbt.func_74764_b("color") ? nbt.func_74762_e("color") : -1;
        if (!isClient) {
            this.inventory.readFromNBT(nbt, "items");
        } else if (oldColor != this.color) {
            this.markBlockForRenderUpdate();
        }
    }

    @Override
    public NBTTagCompound writeNBTData(NBTTagCompound nbt, boolean isClient) {
        if (this.color >= 0) {
            nbt.func_74768_a("color", this.color);
        }
        if (!isClient) {
            this.inventory.writeToNBT(nbt, "items");
        }
        return nbt;
    }

    @Override
    public void dropContents() {
        InventoryHelper.func_180175_a((World)this.func_145831_w(), (BlockPos)this.field_174879_c, (IInventory)this);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory.func_70301_a(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.inventory.func_70298_a(index, count);
    }

    public ItemStack func_70304_b(int index) {
        return this.inventory.func_70304_b(index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventory.func_70299_a(index, stack);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public void func_174889_b(EntityPlayer player) {
        this.inventory.func_174889_b(player);
        if (this.inventory.watchers.size() == 1) {
            this.field_145850_b.func_184134_a((double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() + 0.5f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f), SoundType.field_185856_i.func_185844_d(), SoundCategory.BLOCKS, 1.0f, 0.6f, false);
        }
    }

    public void func_174886_c(EntityPlayer player) {
        this.inventory.func_174886_c(player);
        if (this.inventory.watchers.size() == 0) {
            this.field_145850_b.func_184134_a((double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() + 0.5f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f), SoundType.field_185856_i.func_185844_d(), SoundCategory.BLOCKS, 0.8f, 0.4f, false);
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.inventory.func_94041_b(index, stack);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return "Backpack";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation("tile.charset.backpack.name", new Object[0]);
    }

    @Override
    public void onInventoryChanged(IInventory inventory) {
        this.func_70296_d();
    }

    public boolean hasFastRenderer() {
        return true;
    }
}

