/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.pipes.pipe;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.util.vector.Vector3f;
import pl.asie.charset.lib.multipart.MultipartSpecialRendererBase;
import pl.asie.charset.lib.render.ModelTransformer;
import pl.asie.charset.lib.render.SimpleBakedModel;
import pl.asie.charset.lib.utils.RenderUtils;
import pl.asie.charset.pipes.pipe.PartPipe;
import pl.asie.charset.pipes.pipe.PipeFluidContainer;
import pl.asie.charset.pipes.pipe.PipeItem;

public class SpecialRendererPipe
extends MultipartSpecialRendererBase<PartPipe> {
    private static final Random PREDICTIVE_ITEM_RANDOM = new Random();
    private static final float ITEM_RANDOM_OFFSET = 0.01f;
    private static final float TANK_MIN = 4.01f;
    private static final float TANK_MAX = 11.99f;
    private static final Vector3f[] TANK_FROM = new Vector3f[]{new Vector3f(4.01f, 0.0f, 4.01f), new Vector3f(4.01f, 11.99f, 4.01f), new Vector3f(4.01f, 4.01f, 0.0f), new Vector3f(4.01f, 4.01f, 11.99f), new Vector3f(0.0f, 4.01f, 4.01f), new Vector3f(11.99f, 4.01f, 4.01f), new Vector3f(4.01f, 4.01f, 4.01f)};
    private final Vector3f[] TANK_TO = new Vector3f[]{new Vector3f(11.99f, 4.01f, 11.99f), new Vector3f(11.99f, 16.0f, 11.99f), new Vector3f(11.99f, 11.99f, 4.01f), new Vector3f(11.99f, 11.99f, 16.0f), new Vector3f(4.01f, 11.99f, 11.99f), new Vector3f(16.0f, 11.99f, 11.99f), new Vector3f(11.99f, 11.99f, 11.99f)};
    private final BlockModelRenderer renderer = this.mc.func_175602_ab().func_175019_b();
    private final RenderItem renderItem = this.mc.func_175599_af();
    private final ItemColors itemColors = this.mc.getItemColors();
    private final IBlockState DEFAULT_STATE = Blocks.field_150350_a.func_176223_P();
    private final ItemModelTransformer ITEM_MODEL_TRANSFORMER = new ItemModelTransformer();
    private final Cache<ItemStack, IBakedModel> itemModelCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private final Cache<FluidEntry, IBakedModel> fluidModelCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
    private final Set<PipeItem> SLOW_ITEMS = new HashSet<PipeItem>();

    private IBakedModel renderFluidCube(IBlockAccess world, BlockPos pos, Vector3f from, Vector3f to, FluidEntry entry, VertexBuffer buffer) {
        TextureMap map = Minecraft.func_71410_x().func_147117_R();
        TextureAtlasSprite sprite = map.getTextureExtry(entry.stack.getFluid().getStill().toString());
        if (sprite == null && (sprite = map.getTextureExtry(TextureMap.field_174945_f.toString())) == null) {
            return null;
        }
        SimpleBakedModel smodel = new SimpleBakedModel();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            smodel.addQuad(null, RenderUtils.bakeFace(from, to, facing, sprite, -1));
        }
        if (entry.color == -1) {
            return smodel;
        }
        return ModelTransformer.transform((IBakedModel)smodel, entry.stack.getFluid().getBlock().func_176223_P(), 0L, new FluidColorTransformer(entry.color));
    }

    private float getItemScale(PipeItem item) {
        return item.stack.func_77973_b() instanceof ItemBlock ? 0.35f : 0.4f;
    }

    private float[] calculateItemOffset(PipeItem item, float partialTicks) {
        float[] offset;
        EnumFacing id = item.getDirection();
        if (id == null) {
            return new float[]{0.5f, 0.5f, 0.5f};
        }
        if (partialTicks == 0.0f || item.isStuck() || !item.hasReachedCenter() && item.getProgress() == 0.5f) {
            offset = new float[]{item.getX(), item.getY(), item.getZ()};
        } else {
            float partialMul = partialTicks * 8.0f / 128.0f;
            offset = new float[]{item.getX() + partialMul * (float)id.func_82601_c(), item.getY() + partialMul * (float)id.func_96559_d(), item.getZ() + partialMul * (float)id.func_82599_e()};
        }
        PREDICTIVE_ITEM_RANDOM.setSeed(item.id);
        switch (id.func_176740_k()) {
            case Y: 
            case X: {
                offset[0] = offset[0] + PREDICTIVE_ITEM_RANDOM.nextFloat() * 0.01f;
                break;
            }
            case Z: {
                offset[2] = offset[2] + PREDICTIVE_ITEM_RANDOM.nextFloat() * 0.01f;
            }
        }
        return offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderMultipartFast(PartPipe part, double x, double y, double z, float partialTicks, int destroyStage, VertexBuffer buffer) {
        IBakedModel model;
        if (part == null) {
            return;
        }
        BlockPos pos = part.getPos();
        buffer.func_178969_c(x - (double)pos.func_177958_n(), y - (double)pos.func_177956_o(), z - (double)pos.func_177952_p());
        FluidStack fluidType = part.fluid.fluidStack;
        if (fluidType != null) {
            World world = part.getWorld();
            for (int i = 0; i < part.fluid.tanks.length; ++i) {
                PipeFluidContainer.Tank tank = part.fluid.tanks[i];
                if (tank.amount <= 0) continue;
                FluidStack stack = fluidType.copy();
                stack.amount = tank.amount;
                FluidEntry entry = new FluidEntry(stack, part.fluid.fluidColor, tank.location);
                model = (IBakedModel)this.fluidModelCache.getIfPresent((Object)entry);
                if (model == null) {
                    Vector3f from = TANK_FROM[i];
                    Vector3f to = this.TANK_TO[i];
                    to = new Vector3f(to.x, to.y + (from.y - to.y) * (1.0f - (float)tank.amount / (float)tank.getCapacity()), to.z);
                    model = this.renderFluidCube((IBlockAccess)world, pos, from, to, entry, buffer);
                    this.fluidModelCache.put((Object)entry, (Object)model);
                }
                this.renderer.func_187498_b((IBlockAccess)world, model, entry.stack.getFluid().getBlock().func_176223_P(), pos, buffer, false, 0L);
            }
        }
        Collection<PipeItem> collection = part.getPipeItems();
        synchronized (collection) {
            for (PipeItem item : part.getPipeItems()) {
                EnumFacing id = item.getDirection();
                ItemStack stack = item.getStack();
                if (stack == null || stack.func_77973_b() == null) continue;
                model = (IBakedModel)this.itemModelCache.getIfPresent((Object)stack);
                if (model == null) {
                    model = this.renderItem.func_184393_a(stack, part.getWorld(), null);
                    this.itemModelCache.put((Object)stack, (Object)model);
                }
                if (model.func_188618_c()) {
                    if (!part.renderFast) {
                        this.SLOW_ITEMS.add(item);
                        continue;
                    }
                    part.renderFast = false;
                    continue;
                }
                this.ITEM_MODEL_TRANSFORMER.stack = stack;
                this.ITEM_MODEL_TRANSFORMER.scale = this.getItemScale(item);
                this.ITEM_MODEL_TRANSFORMER.direction = id;
                ItemModelTransformer.access$502(this.ITEM_MODEL_TRANSFORMER, this.calculateItemOffset(item, partialTicks));
                this.renderer.func_178267_a((IBlockAccess)this.getWorld(), ModelTransformer.transform(model, this.DEFAULT_STATE, 0L, this.ITEM_MODEL_TRANSFORMER), this.DEFAULT_STATE, pos, buffer, false);
            }
        }
        buffer.func_178969_c(0.0, 0.0, 0.0);
    }

    public void renderMultipartAt(PartPipe part, double x, double y, double z, float partialTicks, int destroyStage) {
        if (part == null) {
            return;
        }
        this.renderMultipartFastFromSlow(part, x, y, z, partialTicks, destroyStage);
        if (this.SLOW_ITEMS.size() > 0) {
            for (PipeItem item : this.SLOW_ITEMS) {
                EnumFacing id = item.getDirection();
                ItemStack stack = item.getStack();
                float scale = this.getItemScale(item);
                float[] offset = this.calculateItemOffset(item, partialTicks);
                GlStateManager.func_179094_E();
                IBakedModel model = (IBakedModel)this.itemModelCache.getIfPresent((Object)stack);
                if (model == null) {
                    model = this.renderItem.func_184393_a(stack, part.getWorld(), null);
                }
                GlStateManager.func_179137_b((double)(x + (double)offset[0]), (double)(y + (double)offset[1]), (double)(z + (double)offset[2]));
                GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
                if (id != null) {
                    GlStateManager.func_179114_b((float)(270.0f - id.func_185119_l()), (float)0.0f, (float)1.0f, (float)0.0f);
                }
                this.renderItem.func_180454_a(stack, model);
                GlStateManager.func_179121_F();
            }
            this.SLOW_ITEMS.clear();
        } else {
            part.renderFast = true;
        }
    }

    public void clearCache() {
        this.itemModelCache.invalidateAll();
        this.fluidModelCache.invalidateAll();
    }

    private class FluidEntry {
        public final FluidStack stack;
        public final int side;
        public final int color;
        private final int hash;

        public FluidEntry(FluidStack stack, int color, EnumFacing side) {
            this.stack = stack;
            this.color = color;
            this.side = side != null ? side.ordinal() : 6;
            this.hash = Objects.hash(stack, color, side);
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof FluidEntry)) {
                return false;
            }
            FluidEntry f = (FluidEntry)o;
            return f.stack.getFluid() == this.stack.getFluid() && f.stack.amount == this.stack.amount && f.color == this.color && f.side == this.side;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private final class ItemModelTransformer
    implements ModelTransformer.IVertexTransformer {
        private ItemStack stack;
        private float[] offset;
        private float scale;
        private EnumFacing direction;

        private ItemModelTransformer() {
        }

        @Override
        public float[] transform(BakedQuad quad, VertexFormatElement element, float ... data) {
            block10: {
                block9: {
                    if (element.func_177375_c() != VertexFormatElement.EnumUsage.POSITION) break block9;
                    if (this.direction != null) {
                        float z = data[0];
                        switch (this.direction) {
                            case WEST: {
                                data[0] = 1.0f - data[0];
                                data[2] = 1.0f - data[2];
                                break;
                            }
                            case NORTH: {
                                data[0] = data[2];
                                data[2] = 1.0f - z;
                                break;
                            }
                            case SOUTH: {
                                data[0] = 1.0f - data[2];
                                data[2] = z;
                            }
                        }
                    }
                    for (int i = 0; i < 3; ++i) {
                        data[i] = (data[i] - 0.5f) * this.scale + this.offset[i];
                    }
                    break block10;
                }
                if (element.func_177375_c() != VertexFormatElement.EnumUsage.COLOR || !quad.func_178212_b()) break block10;
                int k = SpecialRendererPipe.this.itemColors.func_186728_a(this.stack, quad.func_178211_c());
                if (EntityRenderer.field_78517_a) {
                    k = TextureUtil.func_177054_c((int)k);
                }
                for (int i = 0; i < Math.min(data.length, 3); ++i) {
                    data[i] = data[i] * (float)(k >> (2 - i) * 8 & 0xFF) / 255.0f;
                }
            }
            return data;
        }

        static /* synthetic */ float[] access$502(ItemModelTransformer x0, float[] x1) {
            x0.offset = x1;
            return x1;
        }
    }

    private final class FluidColorTransformer
    implements ModelTransformer.IVertexTransformer {
        private final int color;

        public FluidColorTransformer(int color) {
            this.color = color;
        }

        @Override
        public float[] transform(BakedQuad quad, VertexFormatElement element, float ... data) {
            if (element.func_177375_c() == VertexFormatElement.EnumUsage.COLOR) {
                for (int i = 0; i < Math.min(data.length, 4); ++i) {
                    data[i] = data[i] * (float)(this.color >> i * 8 & 0xFF) / 255.0f;
                }
            }
            return data;
        }
    }
}

