/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.wires;

import mcmultipart.microblock.IMicroblock;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.ISlottedPart;
import mcmultipart.multipart.MultipartHelper;
import mcmultipart.multipart.PartSlot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.lib.wires.PartWire;

public final class WireUtils {
    private static final EnumFacing[][] CONNECTION_DIRS = new EnumFacing[][]{{EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.SOUTH, EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.WEST, EnumFacing.EAST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.WEST}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.NORTH}, {EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH}, {EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST}};

    private WireUtils() {
    }

    public static EnumFacing[] getConnectionsForRender(WireFace face) {
        return CONNECTION_DIRS[face.ordinal()];
    }

    private static boolean isBlockingPart(IMultipartContainer container, PartSlot slot) {
        ISlottedPart part = container.getPartInSlot(slot);
        if (part instanceof IMicroblock.IFaceMicroblock) {
            return !((IMicroblock.IFaceMicroblock)part).isEdgeHollow();
        }
        return part != null;
    }

    public static boolean canConnectInternal(PartWire wire, WireFace side) {
        WireFace location = wire.location;
        IMultipartContainer container = wire.getContainer();
        if (side == location) {
            return false;
        }
        if (side != WireFace.CENTER && location != WireFace.CENTER && WireUtils.isBlockingPart(container, PartSlot.getEdgeSlot((EnumFacing)side.facing, (EnumFacing)location.facing))) {
            return false;
        }
        PartWire wire2 = WireUtils.getWire(container, side);
        return wire2 != null && wire2.calculateConnectionWire(wire);
    }

    public static boolean canConnectExternal(PartWire wire, EnumFacing facing) {
        PartWire wire2;
        IMultipartContainer container = wire.getContainer();
        if (WireUtils.isBlockingPart(container, PartSlot.getFaceSlot((EnumFacing)facing))) {
            return false;
        }
        if (wire.location != WireFace.CENTER && WireUtils.isBlockingPart(container, PartSlot.getEdgeSlot((EnumFacing)facing, (EnumFacing)wire.location.facing))) {
            return false;
        }
        BlockPos pos2 = wire.getPos().func_177972_a(facing);
        IMultipartContainer container2 = MultipartHelper.getPartContainer((IBlockAccess)wire.getWorld(), (BlockPos)pos2);
        if (container2 != null && (wire2 = WireUtils.getWire(container2, wire.location)) != null) {
            if (WireUtils.isBlockingPart(container2, PartSlot.getFaceSlot((EnumFacing)facing.func_176734_d()))) {
                return false;
            }
            if (wire2.isOccluded(facing.func_176734_d())) {
                return false;
            }
            if (wire.location != WireFace.CENTER && WireUtils.isBlockingPart(container2, PartSlot.getEdgeSlot((EnumFacing)facing.func_176734_d(), (EnumFacing)wire.location.facing))) {
                return false;
            }
            return wire2.calculateConnectionWire(wire);
        }
        return wire.calculateConnectionNonWire(wire.getPos().func_177972_a(facing), facing.func_176734_d());
    }

    public static boolean canConnectCorner(PartWire wire, EnumFacing direction) {
        if (wire.location == WireFace.CENTER || wire.isCornerOccluded(direction)) {
            return false;
        }
        EnumFacing side = wire.location.facing;
        IMultipartContainer container = wire.getContainer();
        if (WireUtils.isBlockingPart(container, PartSlot.getFaceSlot((EnumFacing)direction)) || WireUtils.isBlockingPart(container, PartSlot.getEdgeSlot((EnumFacing)direction, (EnumFacing)wire.location.facing))) {
            return false;
        }
        BlockPos middlePos = wire.getPos().func_177972_a(direction);
        if (wire.getWorld().isSideSolid(middlePos, direction.func_176734_d()) || wire.getWorld().isSideSolid(middlePos, side.func_176734_d())) {
            return false;
        }
        BlockPos cornerPos = middlePos.func_177972_a(side);
        container = MultipartHelper.getPartContainer((IBlockAccess)wire.getWorld(), (BlockPos)cornerPos);
        if (container == null) {
            return false;
        }
        if (WireUtils.isBlockingPart(container, PartSlot.getFaceSlot((EnumFacing)side.func_176734_d())) || WireUtils.isBlockingPart(container, PartSlot.getEdgeSlot((EnumFacing)side.func_176734_d(), (EnumFacing)direction.func_176734_d()))) {
            return false;
        }
        PartWire wire2 = WireUtils.getWire(container, WireFace.get(direction.func_176734_d()));
        if (wire2 == null || wire2.isCornerOccluded(side.func_176734_d()) || !wire2.calculateConnectionWire(wire)) {
            return false;
        }
        container = MultipartHelper.getPartContainer((IBlockAccess)wire.getWorld(), (BlockPos)middlePos);
        return container == null || !WireUtils.isBlockingPart(container, PartSlot.getFaceSlot((EnumFacing)direction.func_176734_d())) && !WireUtils.isBlockingPart(container, PartSlot.getFaceSlot((EnumFacing)side)) && !WireUtils.isBlockingPart(container, PartSlot.getEdgeSlot((EnumFacing)direction.func_176734_d(), (EnumFacing)side));
    }

    public static PartSlot getSlotForFace(WireFace face) {
        return PartSlot.VALUES[face.ordinal()];
    }

    public static PartWire getWire(IMultipartContainer container, WireFace face) {
        if (container != null) {
            ISlottedPart part = container.getPartInSlot(WireUtils.getSlotForFace(face));
            return part instanceof PartWire ? (PartWire)part : null;
        }
        return null;
    }
}

