/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.material;

import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.lib.utils.MiscUtils;
import pl.asie.charset.lib.utils.RenderUtils;

public class ColorLookupHandler {
    public static final ColorLookupHandler INSTANCE = new ColorLookupHandler();
    private final TObjectIntMap<Key> COLOR_MAP = new TObjectIntHashMap();

    private ColorLookupHandler() {
    }

    public void clear() {
        this.COLOR_MAP.clear();
    }

    public int getDefaultColor(ItemStack stack) {
        int[] oreIDs = OreDictionary.getOreIDs((ItemStack)stack);
        if (MiscUtils.contains(oreIDs, OreDictionary.getOreID((String)"logWood"))) {
            return -9216455;
        }
        IBlockState state = ItemUtils.getBlockState(stack);
        return state.func_185904_a().func_151565_r().field_76291_p | 0xFF000000;
    }

    public int getColor(ItemStack stack, RenderUtils.AveragingMode mode) {
        Key key = new Key(stack, mode);
        if (!this.COLOR_MAP.containsKey((Object)key)) {
            TextureAtlasSprite sprite = RenderUtils.getSprite(stack);
            if (sprite.func_94215_i().endsWith("missingno")) {
                this.COLOR_MAP.put((Object)key, this.getDefaultColor(stack));
            } else {
                this.COLOR_MAP.put((Object)key, RenderUtils.getAverageColor(sprite, mode));
            }
        }
        return this.COLOR_MAP.get((Object)key);
    }

    public static class Key {
        public final RenderUtils.AveragingMode averagingMode;
        public final ItemStack stack;
        private final int hash;

        public Key(ItemStack stack, RenderUtils.AveragingMode mode) {
            this.stack = stack;
            this.averagingMode = mode;
            this.hash = Item.func_150891_b((Item)stack.func_77973_b()) * 21 + stack.func_77960_j() * 3 + mode.ordinal();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Key)) {
                return false;
            }
            Key k = (Key)o;
            if (k.averagingMode != this.averagingMode || k.stack.func_77973_b() != this.stack.func_77973_b() || k.stack.func_77960_j() != this.stack.func_77960_j()) {
                return false;
            }
            return !this.stack.func_77942_o() || !k.stack.func_77942_o() || this.stack.func_77978_p().equals((Object)k.stack.func_77978_p());
        }
    }
}

