/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.factorization;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.factorization.Quaternion;
import pl.asie.charset.lib.factorization.SpaceUtil;

public enum FzOrientation {
    FACE_DOWN_POINT_SOUTH(EnumFacing.DOWN, EnumFacing.SOUTH),
    FACE_DOWN_POINT_NORTH(EnumFacing.DOWN, EnumFacing.NORTH),
    FACE_DOWN_POINT_EAST(EnumFacing.DOWN, EnumFacing.EAST),
    FACE_DOWN_POINT_WEST(EnumFacing.DOWN, EnumFacing.WEST),
    FACE_UP_POINT_SOUTH(EnumFacing.UP, EnumFacing.SOUTH),
    FACE_UP_POINT_NORTH(EnumFacing.UP, EnumFacing.NORTH),
    FACE_UP_POINT_EAST(EnumFacing.UP, EnumFacing.EAST),
    FACE_UP_POINT_WEST(EnumFacing.UP, EnumFacing.WEST),
    FACE_NORTH_POINT_UP(EnumFacing.NORTH, EnumFacing.UP),
    FACE_NORTH_POINT_DOWN(EnumFacing.NORTH, EnumFacing.DOWN),
    FACE_NORTH_POINT_EAST(EnumFacing.NORTH, EnumFacing.EAST),
    FACE_NORTH_POINT_WEST(EnumFacing.NORTH, EnumFacing.WEST),
    FACE_SOUTH_POINT_UP(EnumFacing.SOUTH, EnumFacing.UP),
    FACE_SOUTH_POINT_DOWN(EnumFacing.SOUTH, EnumFacing.DOWN),
    FACE_SOUTH_POINT_EAST(EnumFacing.SOUTH, EnumFacing.EAST),
    FACE_SOUTH_POINT_WEST(EnumFacing.SOUTH, EnumFacing.WEST),
    FACE_WEST_POINT_UP(EnumFacing.WEST, EnumFacing.UP),
    FACE_WEST_POINT_DOWN(EnumFacing.WEST, EnumFacing.DOWN),
    FACE_WEST_POINT_SOUTH(EnumFacing.WEST, EnumFacing.SOUTH),
    FACE_WEST_POINT_NORTH(EnumFacing.WEST, EnumFacing.NORTH),
    FACE_EAST_POINT_UP(EnumFacing.EAST, EnumFacing.UP),
    FACE_EAST_POINT_DOWN(EnumFacing.EAST, EnumFacing.DOWN),
    FACE_EAST_POINT_SOUTH(EnumFacing.EAST, EnumFacing.SOUTH),
    FACE_EAST_POINT_NORTH(EnumFacing.EAST, EnumFacing.NORTH);

    public final EnumFacing facing;
    public final EnumFacing top;
    private FzOrientation nextFaceRotation;
    private FzOrientation prevFaceRotation;
    private int rotation;
    private FzOrientation swapped;
    private EnumFacing[] dirRotations = new EnumFacing[EnumFacing.values().length];
    private static FzOrientation[] valuesCache;

    private FzOrientation(EnumFacing facing, EnumFacing top) {
        this.facing = facing;
        this.top = top;
    }

    private void setup() {
        this.nextFaceRotation = FzOrientation.find(this.facing, SpaceUtil.rotate(this.top, this.facing));
        this.prevFaceRotation = FzOrientation.find(this.facing, SpaceUtil.rotateBack(this.top, this.facing));
    }

    private void setupRotation() {
        int rcount = 0;
        FzOrientation head = FzOrientation.fromDirection(this.facing);
        for (int i = 0; i < 5; ++i) {
            if (head == this) {
                this.rotation = rcount;
            }
            ++rcount;
            head = head.nextFaceRotation;
        }
    }

    private void setupDirectionRotation() {
        for (EnumFacing dir : EnumFacing.values()) {
            Vec3d v = SpaceUtil.fromDirection(dir);
            Quaternion.fromOrientation(this).applyRotation(v);
            this.dirRotations[dir.ordinal()] = SpaceUtil.round(v, null);
        }
    }

    private static FzOrientation find(EnumFacing f, EnumFacing t) {
        for (FzOrientation o : FzOrientation.values()) {
            if (o.facing != f || o.top != t) continue;
            return o;
        }
        return null;
    }

    public FzOrientation rotateOnFace(int count) {
        if ((count %= 4) > 0) {
            FzOrientation here = this;
            while (count > 0) {
                --count;
                here = here.nextFaceRotation;
            }
            return here;
        }
        if (count < 0) {
            FzOrientation here = this;
            while (count < 0) {
                ++count;
                here = here.prevFaceRotation;
            }
            return here;
        }
        return this;
    }

    public FzOrientation getNextRotationOnFace() {
        return this.nextFaceRotation;
    }

    public FzOrientation getPrevRotationOnFace() {
        return this.prevFaceRotation;
    }

    public FzOrientation getNextRotationOnTop() {
        return this.getSwapped().getNextRotationOnFace().getSwapped();
    }

    public FzOrientation getPrevRotationOnTop() {
        return this.getSwapped().getPrevRotationOnFace().getSwapped();
    }

    public FzOrientation rotateOnTop(int count) {
        return this.getSwapped().rotateOnFace(count).getSwapped();
    }

    public static FzOrientation getOrientation(int index) {
        if (index >= 0 && index < valuesCache.length) {
            return valuesCache[index];
        }
        return null;
    }

    public static FzOrientation fromDirection(EnumFacing dir) {
        if (dir == null) {
            return null;
        }
        return valuesCache[dir.ordinal() * 4];
    }

    @SideOnly(value=Side.CLIENT)
    private static Matrix4f newMat() {
        Matrix4f ret = new Matrix4f();
        ret.setIdentity();
        return ret;
    }

    @SideOnly(value=Side.CLIENT)
    public TRSRTransformation toTransformation() {
        Quaternion fzq = Quaternion.fromOrientation(this.getSwapped());
        Matrix4f trans = FzOrientation.newMat();
        Matrix4f rot = FzOrientation.newMat();
        Matrix4f r90 = FzOrientation.newMat();
        r90.setRotation(new AxisAngle4f(0.0f, 1.0f, 0.0f, 1.5707964f));
        trans.setTranslation(new Vector3f(0.5f, 0.5f, 0.5f));
        Matrix4f iTrans = new Matrix4f(trans);
        iTrans.invert();
        rot.setRotation(fzq.toJavax());
        rot.mul(r90);
        trans.mul(rot);
        trans.mul(iTrans);
        return new TRSRTransformation(trans);
    }

    public FzOrientation pointTopTo(EnumFacing newTop) {
        FzOrientation fzo = this;
        for (int i = 0; i < 4; ++i) {
            if (fzo.top == newTop) {
                return fzo;
            }
            fzo = fzo.nextFaceRotation;
        }
        return null;
    }

    public int getRotation() {
        return this.rotation;
    }

    public Vec3d getDiagonalVector(Vec3d vec) {
        return new Vec3d(this.facing.func_176730_m()).func_178787_e(new Vec3d(this.top.func_176730_m()));
    }

    public FzOrientation getSwapped() {
        return this.swapped;
    }

    public EnumFacing applyRotation(EnumFacing dir) {
        return this.dirRotations[dir.ordinal()];
    }

    static {
        valuesCache = FzOrientation.values();
        for (FzOrientation o : FzOrientation.values()) {
            o.setup();
        }
        for (FzOrientation o : FzOrientation.values()) {
            o.setupRotation();
        }
        block2: for (FzOrientation o : FzOrientation.values()) {
            for (FzOrientation t : FzOrientation.values()) {
                if (o.facing != t.top || o.top != t.facing) continue;
                o.swapped = t;
                continue block2;
            }
        }
        for (FzOrientation o : FzOrientation.values()) {
            o.setupDirectionRotation();
        }
        if (valuesCache.length == 0) {
            throw new RuntimeException("lolwut");
        }
    }
}

