/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.audio;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.network.INetHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.api.audio.AudioData;
import pl.asie.charset.api.audio.AudioPacket;
import pl.asie.charset.api.audio.AudioSink;
import pl.asie.charset.api.audio.IDataPCM;
import pl.asie.charset.lib.audio.IDataSound;
import pl.asie.charset.lib.audio.manager.AudioStreamManagerClient;
import pl.asie.charset.lib.audio.manager.AudioStreamOpenAL;
import pl.asie.charset.lib.audio.manager.IAudioStream;
import pl.asie.charset.lib.network.Packet;

public class PacketAudioData
extends Packet {
    private int id;
    private AudioPacket packet;

    public PacketAudioData() {
    }

    public PacketAudioData(int id, AudioPacket packet) {
        this.id = id;
        this.packet = packet;
    }

    @Override
    public void writeData(ByteBuf buf) {
        buf.writeInt(this.id);
        this.packet.writeData(buf);
    }

    @SideOnly(value=Side.CLIENT)
    private void playSoundNote(AudioPacket packet, IDataSound sound) {
        for (AudioSink sink : packet.getSinks()) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(new SoundEvent(new ResourceLocation(sound.getSoundName())), SoundCategory.BLOCKS, 3.0f * sink.getVolume() * packet.getVolume(), sound.getSoundPitch(), new BlockPos(sink.getPos())));
        }
    }

    @Override
    public void readData(INetHandler handler, ByteBuf buf) {
        IAudioStream stream;
        int id = buf.readInt();
        AudioPacket packet = new AudioPacket();
        packet.readData(buf);
        AudioData audioData = packet.getData();
        if (audioData instanceof IDataSound) {
            IDataSound sound = (IDataSound)((Object)audioData);
            this.playSoundNote(packet, sound);
            return;
        }
        if (!(audioData instanceof IDataPCM) || ((IDataPCM)((Object)audioData)).getSampleSize() != 1) {
            return;
        }
        IDataPCM pcmPacket = (IDataPCM)((Object)audioData);
        byte[] data = pcmPacket.getSamplePCMData();
        if (pcmPacket.isSampleSigned()) {
            byte[] data2 = new byte[data.length];
            for (int i = 0; i < data.length; ++i) {
                data2[i] = (byte)(data[i] ^ 0x80);
            }
            data = data2;
        }
        if ((stream = AudioStreamManagerClient.INSTANCE.get(id)) == null) {
            stream = new AudioStreamOpenAL(false, false, 8);
            AudioStreamManagerClient.INSTANCE.put(id, stream);
        }
        stream.setSampleRate(pcmPacket.getSampleRate());
        stream.push(data);
        for (AudioSink sink : packet.getSinks()) {
            try {
                stream.play((float)sink.getPos().field_72450_a, (float)sink.getPos().field_72448_b, (float)sink.getPos().field_72449_c, sink.getDistance(), sink.getVolume() * packet.getVolume());
            }
            catch (Exception exception) {}
        }
    }
}

