/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.gates.render;

import com.google.common.collect.ImmutableMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import pl.asie.charset.gates.ItemGate;
import pl.asie.charset.gates.PartGate;
import pl.asie.charset.gates.render.GateRenderDefinitions;
import pl.asie.charset.lib.render.ModelFactory;
import pl.asie.charset.lib.render.SimpleBakedModel;
import pl.asie.charset.lib.utils.RenderUtils;

public class RendererGate
extends ModelFactory<PartGate> {
    public static final RendererGate INSTANCE = new RendererGate();
    private static final ModelRotation[] ROTATIONS_SIDE = new ModelRotation[]{ModelRotation.X0_Y0, ModelRotation.X180_Y0, ModelRotation.X270_Y0, ModelRotation.X270_Y180, ModelRotation.X270_Y270, ModelRotation.X270_Y90};
    private static final ModelRotation[] ROTATIONS_TOP = new ModelRotation[]{ModelRotation.X0_Y0, ModelRotation.X0_Y0, ModelRotation.X0_Y0, ModelRotation.X0_Y180, ModelRotation.X0_Y270, ModelRotation.X0_Y90};
    private static final Map<String, IModel> layerModels = new HashMap<String, IModel>();

    public RendererGate() {
        super(PartGate.PROPERTY, new ResourceLocation("charsetgates:blocks/gate_bottom"));
        this.addDefaultBlockTransforms();
    }

    @Override
    public IBakedModel bake(PartGate gate, boolean isItem, BlockRenderLayer blockRenderLayer) {
        SimpleBakedModel result = new SimpleBakedModel((IBakedModel)this);
        ModelStateComposition transform = new ModelStateComposition((IModelState)new TRSRTransformation(ROTATIONS_SIDE[gate.getSide().ordinal()]), (IModelState)new TRSRTransformation(ROTATIONS_TOP[gate.getTop().ordinal()]));
        if (gate.isMirrored()) {
            transform = new ModelStateComposition((IModelState)transform, (IModelState)new TRSRTransformation(null, null, new Vector3f(-1.0f, 1.0f, 1.0f), null));
        }
        GateRenderDefinitions.Definition definition = GateRenderDefinitions.INSTANCE.getGateDefinition(gate.getType());
        GateRenderDefinitions.BaseDefinition base = GateRenderDefinitions.INSTANCE.base;
        IModel model = definition.getModel(gate.getModelName());
        if (model != null) {
            result.addModel(model.bake((IModelState)transform, DefaultVertexFormats.field_176600_a, RenderUtils.textureGetter));
        }
        IRetexturableModel layerModel = (IRetexturableModel)definition.getModel("layer");
        int i = 0;
        for (GateRenderDefinitions.Layer layer : definition.layers) {
            PartGate.State state;
            if ((state = gate.getLayerState(i++)) == PartGate.State.NO_RENDER) continue;
            ModelStateComposition layerTransform = transform;
            if (layer.height != 0) {
                layerTransform = new ModelStateComposition((IModelState)new TRSRTransformation(new Vector3f(0.0f, (float)layer.height / 16.0f, 0.0f), null, null, null), (IModelState)transform);
            }
            if ("color".equals(layer.type) && layer.texture != null) {
                model = layerModels.get(layer.texture);
                if (model == null) {
                    model = layerModel.retexture(ImmutableMap.of((Object)"layer", (Object)layer.texture));
                    layerModels.put(layer.texture, model);
                }
                IBakedModel bakedModel = model.bake((IModelState)layerTransform, DefaultVertexFormats.field_176600_a, RenderUtils.textureGetter);
                int color = state == PartGate.State.ON ? base.colorMul.get("on") : (state == PartGate.State.OFF ? base.colorMul.get("off").intValue() : base.colorMul.get("disabled").intValue());
                result.addModel(bakedModel, color);
                continue;
            }
            if (!"map".equals(layer.type) || layer.textures == null) continue;
            String texture = layer.textures.get(state.name().toLowerCase(Locale.ENGLISH));
            if (texture == null && (texture = layer.textures.get("off")) == null) {
                texture = layer.textures.get("disabled");
            }
            if (texture == null) continue;
            model = layerModels.get(texture);
            if (model == null) {
                model = layerModel.retexture(ImmutableMap.of((Object)"layer", (Object)texture));
                layerModels.put(texture, model);
            }
            result.addModel(model.bake((IModelState)layerTransform, DefaultVertexFormats.field_176600_a, RenderUtils.textureGetter));
        }
        EnumSet<EnumFacing> invertedSides = EnumSet.noneOf(EnumFacing.class);
        i = 0;
        for (GateRenderDefinitions.Torch torch : definition.torches) {
            PartGate.State state;
            if ((state = gate.getTorchState(i++)) == PartGate.State.NO_RENDER) continue;
            if (torch.inverter != null) {
                EnumFacing inverter = EnumFacing.func_176739_a((String)torch.inverter);
                if (!gate.isSideInverted(inverter)) continue;
                invertedSides.add(inverter);
            }
            result.addModel(definition.getModel(state == PartGate.State.ON ? "torch_on" : "torch_off").bake((IModelState)new ModelStateComposition((IModelState)transform, (IModelState)new TRSRTransformation(new Vector3f((torch.pos[0] - 7.5f) / 16.0f, 0.0f, (torch.pos[1] - 7.5f) / 16.0f), null, null, null)), DefaultVertexFormats.field_176600_a, RenderUtils.textureGetter));
        }
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (!gate.isSideInverted(facing) || invertedSides.contains(facing)) continue;
            result.addModel(definition.getModel(gate.getInverterState(facing) ? "torch_on" : "torch_off").bake((IModelState)new ModelStateComposition((IModelState)transform, (IModelState)new TRSRTransformation(new Vector3f((float)(facing.func_82601_c() * 7) / 16.0f, 0.0f, (float)(facing.func_82599_e() * 7) / 16.0f), null, null, null)), DefaultVertexFormats.field_176600_a, RenderUtils.textureGetter));
        }
        return result;
    }

    @Override
    public PartGate fromItemStack(ItemStack stack) {
        return ItemGate.getPartGate(stack);
    }

    @Override
    public ItemOverrideList func_188617_f() {
        this.addThirdPersonTransformation(RendererGate.getTransformation(0.0f, 2.5f, 2.75f, 75.0f, 45.0f, 0.0f, 0.375f));
        return super.func_188617_f();
    }
}

