/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.gates;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import pl.asie.charset.gates.PartGate;

public class PartGatePulseFormer
extends PartGate {
    private byte pulse;

    @Override
    public boolean canBlockSide(EnumFacing side) {
        return false;
    }

    @Override
    public boolean canInvertSide(EnumFacing side) {
        return side == EnumFacing.SOUTH;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74774_a("pl", this.pulse);
        return tag;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.pulse = tag.func_74771_c("pl");
        super.readFromNBT(tag);
    }

    @Override
    protected void onChanged() {
        boolean changed;
        if (this.pulse == 0 && (changed = super.tick())) {
            this.pulse = this.getValueInside(EnumFacing.SOUTH);
            if (this.pulse != 0) {
                this.scheduleTick();
            }
            super.tick();
            this.notifyBlockUpdate();
            this.sendUpdatePacket();
        }
    }

    @Override
    protected boolean tick() {
        boolean changed = this.pulse != 0;
        this.pulse = 0;
        return changed |= super.tick();
    }

    @Override
    public PartGate.Connection getType(EnumFacing dir) {
        if (dir == EnumFacing.NORTH) {
            return PartGate.Connection.OUTPUT;
        }
        if (dir == EnumFacing.SOUTH) {
            return PartGate.Connection.INPUT;
        }
        return PartGate.Connection.NONE;
    }

    @Override
    public PartGate.State getLayerState(int id) {
        boolean hasSignal = this.getValueInside(EnumFacing.SOUTH) != 0;
        switch (id) {
            case 0: {
                return PartGate.State.input(this.getValueInside(EnumFacing.SOUTH));
            }
            case 1: 
            case 2: {
                return PartGate.State.bool(!hasSignal);
            }
            case 3: {
                return PartGate.State.bool(hasSignal);
            }
            case 4: {
                return PartGate.State.input(this.getValueOutside(EnumFacing.NORTH));
            }
        }
        return PartGate.State.OFF;
    }

    @Override
    public PartGate.State getTorchState(int id) {
        switch (id) {
            case 0: {
                return PartGate.State.input(this.getValueInside(EnumFacing.SOUTH)).invert();
            }
            case 1: {
                return PartGate.State.input(this.getValueInside(EnumFacing.SOUTH));
            }
            case 2: {
                return PartGate.State.input(this.getValueInside(EnumFacing.NORTH)).invert();
            }
        }
        return PartGate.State.ON;
    }

    @Override
    protected byte calculateOutputInside(EnumFacing side) {
        return this.pulse;
    }
}

