/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.gates;

import net.minecraft.util.EnumFacing;
import pl.asie.charset.gates.PartGate;

public class PartGateBuffer
extends PartGate {
    @Override
    public boolean canBlockSide(EnumFacing side) {
        return side == EnumFacing.WEST || side == EnumFacing.EAST;
    }

    @Override
    public boolean canInvertSide(EnumFacing side) {
        return true;
    }

    @Override
    public PartGate.Connection getType(EnumFacing dir) {
        return dir == EnumFacing.SOUTH ? PartGate.Connection.INPUT_ANALOG : PartGate.Connection.OUTPUT;
    }

    @Override
    public PartGate.State getLayerState(int id) {
        switch (id) {
            case 0: {
                if (!this.isSideOpen(EnumFacing.WEST)) {
                    return PartGate.State.DISABLED;
                }
                return PartGate.State.input(this.getValueInside(EnumFacing.WEST));
            }
            case 1: {
                if (!this.isSideOpen(EnumFacing.EAST)) {
                    return PartGate.State.DISABLED;
                }
                return PartGate.State.input(this.getValueInside(EnumFacing.EAST));
            }
            case 2: {
                return PartGate.State.input(this.getValueInside(EnumFacing.NORTH)).invert();
            }
            case 3: {
                return PartGate.State.input(this.getValueInside(EnumFacing.NORTH));
            }
        }
        return PartGate.State.OFF;
    }

    @Override
    public PartGate.State getTorchState(int id) {
        switch (id) {
            case 0: {
                return PartGate.State.input(this.getValueInside(EnumFacing.NORTH));
            }
            case 1: {
                return PartGate.State.input(this.getValueInside(EnumFacing.NORTH)).invert();
            }
        }
        return PartGate.State.ON;
    }

    @Override
    protected byte calculateOutputInside(EnumFacing side) {
        switch (side) {
            case NORTH: {
                return this.getValueInside(EnumFacing.SOUTH) > 0 ? (byte)0 : 15;
            }
            case WEST: 
            case EAST: {
                if (this.isSideInverted(EnumFacing.NORTH)) {
                    return this.getValueInside(EnumFacing.SOUTH);
                }
                return this.getValueInside(EnumFacing.SOUTH) > 0 ? (byte)0 : 15;
            }
        }
        return 0;
    }
}

