/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.gates;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import mcmultipart.multipart.MultipartRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import pl.asie.charset.gates.ItemGate;
import pl.asie.charset.gates.PartGate;
import pl.asie.charset.gates.PartGateBuffer;
import pl.asie.charset.gates.PartGateMultiplexer;
import pl.asie.charset.gates.PartGateNAND;
import pl.asie.charset.gates.PartGateNOR;
import pl.asie.charset.gates.PartGatePulseFormer;
import pl.asie.charset.gates.PartGateRSLatch;
import pl.asie.charset.gates.PartGateXOR;
import pl.asie.charset.gates.ProxyCommon;
import pl.asie.charset.lib.ModCharsetLib;
import pl.asie.charset.lib.network.PacketRegistry;
import pl.asie.charset.lib.recipe.IRecipeObject;
import pl.asie.charset.lib.recipe.RecipeCharset;
import pl.asie.charset.lib.wires.WireFactory;
import pl.asie.charset.lib.wires.WireManager;

@Mod(modid="CharsetGates", name="&", version="0.3.0-pre15", dependencies="required-after:Forge@[11.15.0.1715,);required-after:CharsetLib@0.3.0-pre15;required-after:mcmultipart", updateJSON="http://charset.asie.pl/update.json", acceptedMinecraftVersions="[1.10]")
public class ModCharsetGates {
    public static final String MODID = "CharsetGates";
    public static final String NAME = "&";
    public static final String VERSION = "0.3.0-pre15";
    @SidedProxy(clientSide="pl.asie.charset.gates.ProxyClient", serverSide="pl.asie.charset.gates.ProxyCommon")
    public static ProxyCommon proxy;
    @Mod.Instance(value="CharsetGates")
    public static ModCharsetGates INSTANCE;
    public static PacketRegistry packet;
    public static ItemGate itemGate;
    static final String[] gateMeta;
    static final String[] gateUN;
    static final Map<String, Integer> metaGate;
    static final Set<ItemStack> gateStacks;
    static final Map<String, Class<? extends PartGate>> gateParts;
    static final Map<String, ResourceLocation> gateDefintions;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (!ModCharsetLib.moduleEnabled("gates")) {
            return;
        }
        itemGate = new ItemGate();
        GameRegistry.register((IForgeRegistryEntry)itemGate.setRegistryName("gate"));
        this.registerGate("nand", PartGateNAND.class, 0);
        this.registerGate("nor", PartGateNOR.class, 1);
        this.registerGate("xor", PartGateXOR.class, 2);
        this.registerGate("pulse_former", PartGatePulseFormer.class, 3);
        this.registerGate("multiplexer", PartGateMultiplexer.class, 4);
        this.registerGate("rs_latch", PartGateRSLatch.class, 5);
        this.registerGate("buffer", PartGateBuffer.class, 6);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (!ModCharsetLib.moduleEnabled("gates")) {
            return;
        }
        packet = new PacketRegistry(MODID);
        this.registerGateStack(ItemGate.getStack(new PartGateNOR().setInvertedSides(1)), "sts", "scs", "sss");
        this.registerGateStack(ItemGate.getStack(new PartGateNAND().setInvertedSides(1)), "wtw", "ccc", "sws");
        this.registerGateStack(ItemGate.getStack(new PartGateXOR()), "w w", "cwc", "scs");
        this.registerGateStack(ItemGate.getStack(new PartGateNOR()), "s s", "scs", "sss");
        this.registerGateStack(ItemGate.getStack(new PartGateNAND()), "w w", "ccc", "sws");
        this.registerGateStack(ItemGate.getStack(new PartGateXOR().setInvertedSides(1)), "wtw", "cwc", "scs");
        this.registerGateStack(ItemGate.getStack(new PartGatePulseFormer()), "wcw", "cwc", "wws");
        this.registerGateStack(ItemGate.getStack(new PartGateMultiplexer()), "wcw", "csc", "wcw");
        this.registerGateStack(ItemGate.getStack(new PartGateRSLatch()));
        this.registerGateStack(ItemGate.getStack(new PartGateBuffer()));
        this.registerGateStack(ItemGate.getStack(new PartGateBuffer().setInvertedSides(1)));
    }

    public void registerGateStack(ItemStack stack, Object ... recipe) {
        if (recipe.length > 0) {
            ArrayList<Object> data = new ArrayList<Object>();
            for (Object o : recipe) {
                data.add(o);
            }
            data.add(Character.valueOf('c'));
            data.add(new ItemStack(Blocks.field_150429_aA));
            data.add(Character.valueOf('w'));
            data.add(Loader.isModLoaded((String)"CharsetWires") ? new IRecipeObject(){

                @Override
                public boolean matches(ItemStack stack) {
                    if (stack != null && stack.func_77973_b() == WireManager.ITEM) {
                        return WireManager.ITEM.getFactory(stack).getRegistryName().func_110624_b().equals("charsetwires");
                    }
                    return false;
                }

                @Override
                public Object preview() {
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    for (WireFactory f : WireManager.REGISTRY.getValues()) {
                        if (!f.getRegistryName().func_110624_b().equals("charsetwires")) continue;
                        stacks.add(WireManager.ITEM.getStack(f, false));
                        stacks.add(WireManager.ITEM.getStack(f, true));
                    }
                    return stacks;
                }
            } : Items.field_151137_ax);
            data.add(Character.valueOf('s'));
            data.add(new ItemStack((Block)Blocks.field_150333_U));
            GameRegistry.addRecipe((IRecipe)RecipeCharset.Builder.create(stack).shaped(data.toArray(new Object[data.size()])).build());
        }
        this.registerGateStack(stack);
    }

    public void registerGateStack(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof ItemGate) {
            gateStacks.add(stack);
        }
    }

    private void registerGate(String name, Class<? extends PartGate> clazz, int meta) {
        this.registerGate("charsetgates:gate_" + name, clazz, meta, "charsetgates:gatedefs/" + name, "part.charset.gate." + name);
    }

    public void registerGate(String name, Class<? extends PartGate> clazz, int meta, String gdLoc, String unl) {
        gateParts.put(name, clazz);
        gateDefintions.put(name, new ResourceLocation(gdLoc + ".json"));
        ModCharsetGates.gateMeta[meta] = name;
        ModCharsetGates.gateUN[meta] = unl;
        metaGate.put(name, meta);
        MultipartRegistry.registerPart(clazz, (String)name);
        ModCharsetLib.proxy.registerItemModel((Item)itemGate, meta, name);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
    }

    static {
        gateMeta = new String[64];
        gateUN = new String[64];
        metaGate = new HashMap<String, Integer>();
        gateStacks = new HashSet<ItemStack>();
        gateParts = new HashMap<String, Class<? extends PartGate>>();
        gateDefintions = new HashMap<String, ResourceLocation>();
    }
}

