/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.decoration.poster;

import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import pl.asie.charset.decoration.ModCharsetDecoration;
import pl.asie.charset.decoration.poster.EntityPoster;
import pl.asie.charset.lib.ModCharsetLib;
import pl.asie.charset.lib.factorization.Quaternion;
import pl.asie.charset.lib.factorization.SpaceUtil;
import pl.asie.charset.lib.items.ItemBase;

public class ItemPoster
extends ItemBase {
    public ItemPoster() {
        this.func_77637_a(ModCharsetLib.CREATIVE_TAB);
        this.func_77655_b("charset.poster");
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        PosterPlacer placer = new PosterPlacer(stack, playerIn, worldIn, pos, facing);
        if (placer.calculate()) {
            return EnumActionResult.FAIL;
        }
        if (!worldIn.field_72995_K) {
            placer.spawn();
        }
        return EnumActionResult.SUCCESS;
    }

    public static class PosterPlacer {
        private ItemStack is;
        private EntityPlayer player;
        private World w;
        private EnumFacing dir;
        final BlockPos at;
        AxisAlignedBB blockBox = null;
        public EntityPoster result;
        double bestWidth;
        AxisAlignedBB bounds;
        AxisAlignedBB plane;
        Quaternion rot;
        EnumFacing top;

        public PosterPlacer(ItemStack is, EntityPlayer player, World w, BlockPos pos, EnumFacing side) {
            this.is = is;
            this.player = player;
            this.w = w;
            this.dir = side;
            this.at = pos;
        }

        public boolean calculate() {
            if (this.determineBoundingBox()) {
                return true;
            }
            if (this.determineSize()) {
                return true;
            }
            this.determineOrientation();
            EntityPoster poster = new EntityPoster(this.w);
            poster.setBase(this.bestWidth, this.rot, this.dir, this.top, this.bounds);
            Vec3d spot = SpaceUtil.getMiddle(this.plane);
            if (SpaceUtil.sign(this.dir) == -1) {
                spot.func_178787_e(SpaceUtil.scale(SpaceUtil.fromDirection(this.dir), 3.90625E-4));
            }
            SpaceUtil.toEntPos(poster, spot);
            this.result = poster;
            return false;
        }

        private void determineOrientation() {
            double rotationAngle = 0.0;
            if (this.dir.func_176730_m().func_177956_o() == 0) {
                this.top = EnumFacing.UP;
                if (this.dir == EnumFacing.WEST) {
                    rotationAngle = 1.0;
                }
                if (this.dir == EnumFacing.SOUTH) {
                    rotationAngle = 2.0;
                }
                if (this.dir == EnumFacing.EAST) {
                    rotationAngle = 3.0;
                }
            } else {
                this.top = EnumFacing.WEST;
                rotationAngle = -this.dir.func_176730_m().func_177956_o();
            }
            this.rot = Quaternion.getRotationQuaternionRadians(rotationAngle * Math.PI / 2.0, this.top);
        }

        private boolean determineSize() {
            this.plane = SpaceUtil.flatten(this.blockBox, this.dir);
            double pix = 0.0625;
            this.bounds = SpaceUtil.addCoord(this.plane, SpaceUtil.scale(new Vec3d(this.dir.func_176730_m()), 0.0625));
            for (Object ent : this.w.func_72872_a(EntityPoster.class, this.bounds)) {
                if (ent instanceof EntityPoster) {
                    EntityPoster poster = (EntityPoster)((Object)ent);
                    if (poster.inv == null || poster.inv.func_77973_b() != ModCharsetDecoration.posterItem) continue;
                    return true;
                }
                if (ent instanceof EntityItemFrame) continue;
                return true;
            }
            double xwidth = this.plane.field_72336_d - this.plane.field_72340_a;
            double ywidth = this.plane.field_72337_e - this.plane.field_72338_b;
            double zwidth = this.plane.field_72334_f - this.plane.field_72339_c;
            this.bestWidth = SpaceUtil.getDiagonalLength(this.plane);
            if (xwidth != 0.0) {
                this.bestWidth = xwidth;
            }
            if (ywidth != 0.0 && ywidth < this.bestWidth) {
                this.bestWidth = ywidth;
            }
            if (zwidth != 0.0 && zwidth < this.bestWidth) {
                this.bestWidth = zwidth;
            }
            return this.bestWidth <= 0.125;
        }

        private boolean determineBoundingBox() {
            RayTraceResult mop;
            ArrayList boxes = new ArrayList();
            AxisAlignedBB query = new AxisAlignedBB(this.at.func_177982_a(-9, -9, -9), this.at.func_177982_a(9, 9, 9));
            IBlockState state = this.w.func_180495_p(this.at);
            state.func_185908_a(this.w, this.at, query, boxes, (Entity)this.player);
            Vec3d playerEye = SpaceUtil.fromPlayerEyePos(this.player);
            Vec3d look = this.player.func_70040_Z();
            look = SpaceUtil.scale(look, 8.0);
            Vec3d reachEnd = look.func_178787_e(playerEye);
            double minDist = Double.POSITIVE_INFINITY;
            for (AxisAlignedBB box : boxes) {
                double vecLen;
                RayTraceResult mop2 = box.func_72327_a(playerEye, reachEnd);
                if (mop2 == null || mop2.field_72313_a != RayTraceResult.Type.BLOCK || mop2.field_72307_f == null || (vecLen = mop2.field_72307_f.func_72433_c()) > minDist) continue;
                minDist = vecLen;
                this.dir = mop2.field_178784_b;
                this.blockBox = box;
            }
            if (this.blockBox == null) {
                this.blockBox = state.func_185890_d(this.w, this.at);
            }
            if (this.blockBox == null && (mop = state.func_185910_a(this.w, this.at, playerEye, reachEnd)) != null) {
                this.blockBox = state.func_185900_c((IBlockAccess)this.w, this.at);
            }
            return this.blockBox == null;
        }

        public void spawn() {
            this.w.func_72838_d((Entity)this.result);
            this.result.syncData();
            if (!this.player.field_71075_bZ.field_75098_d) {
                --this.is.field_77994_a;
            }
        }
    }
}

