/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.audio.tape;

import java.util.Random;
import mcmultipart.multipart.IMultipart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import pl.asie.charset.api.audio.AudioData;
import pl.asie.charset.api.audio.AudioPacket;
import pl.asie.charset.api.audio.IAudioReceiver;
import pl.asie.charset.api.audio.IDataPCM;
import pl.asie.charset.api.tape.IDataStorage;
import pl.asie.charset.audio.ModCharsetAudio;
import pl.asie.charset.audio.tape.PacketDriveCounter;
import pl.asie.charset.audio.tape.PacketDriveState;
import pl.asie.charset.audio.tape.PartTapeDrive;
import pl.asie.charset.audio.tape.State;
import pl.asie.charset.audio.tape.TapeResampler;
import pl.asie.charset.lib.Capabilities;
import pl.asie.charset.lib.audio.AudioDataDFPWM;
import pl.asie.charset.lib.audio.AudioSinkBlock;
import pl.asie.charset.lib.audio.AudioUtils;
import pl.asie.charset.lib.audio.codec.DFPWM;
import pl.asie.charset.lib.inventory.InventorySimple;
import pl.asie.charset.lib.network.Packet;

public class TapeDriveState
implements ITickable,
IAudioReceiver,
INBTSerializable<NBTTagCompound> {
    protected int counter;
    private final PartTapeDrive owner;
    private final InventorySimple inventory;
    private State state = State.STOPPED;
    private State lastState;
    private Integer sourceId;
    private DFPWM recordDFPWM;
    private AudioPacket receivedPacket;
    private int receivedPacketPos;

    public TapeDriveState(PartTapeDrive owner, InventorySimple inventory) {
        this.owner = owner;
        this.inventory = inventory;
    }

    public void setState(State state) {
        this.lastState = this.state;
        this.state = state;
        if (state != State.RECORDING) {
            this.receivedPacket = null;
            this.recordDFPWM = null;
        }
    }

    public int getCounter() {
        return this.counter;
    }

    public void resetCounter() {
        this.counter = 0;
    }

    private void applyNoise(byte[] data, float noiseThreshold) {
        Random rand = this.owner.getWorld().field_73012_v;
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                if (!(rand.nextFloat() <= noiseThreshold)) continue;
                if (rand.nextBoolean()) {
                    int n = i;
                    data[n] = (byte)(data[n] | 1 << j);
                    continue;
                }
                int n = i;
                data[n] = (byte)(data[n] & ~(1 << j));
            }
        }
    }

    public void func_73660_a() {
        int lastCounter = this.counter;
        if (this.state != State.STOPPED) {
            IDataStorage storage;
            if (this.sourceId == null) {
                this.sourceId = AudioUtils.start();
            }
            boolean found = false;
            ItemStack stack = this.inventory.func_70301_a(0);
            if (stack != null && stack.hasCapability(ModCharsetAudio.CAP_STORAGE, null) && (storage = (IDataStorage)stack.getCapability(ModCharsetAudio.CAP_STORAGE, null)) != null) {
                found = true;
                int rel = storage.getPosition();
                if (this.state == State.PLAYING) {
                    byte[] data = new byte[300];
                    int len = storage.read(data, false);
                    AudioPacket packet = new AudioPacket(new AudioDataDFPWM(data, 50).setSourceId(this.sourceId), 1.0f);
                    boolean received = false;
                    World world = this.owner.getWorld();
                    BlockPos pos = this.owner.getPos();
                    for (EnumFacing facing : EnumFacing.field_82609_l) {
                        TileEntity tile = world.func_175625_s(pos.func_177972_a(facing));
                        if (tile == null || !tile.hasCapability(Capabilities.AUDIO_RECEIVER, facing.func_176734_d())) continue;
                        received |= ((IAudioReceiver)tile.getCapability(Capabilities.AUDIO_RECEIVER, facing.func_176734_d())).receive(packet);
                    }
                    if (!received) {
                        new AudioSinkBlock(this.owner.getWorld(), this.owner.getPos()).receive(packet);
                    }
                    packet.send();
                    if (len < data.length) {
                        this.setState(State.STOPPED);
                    }
                } else if (this.state == State.RECORDING) {
                    AudioData data;
                    byte[] dataOut = new byte[300];
                    if (this.receivedPacket != null && (data = this.receivedPacket.getData()) instanceof IDataPCM) {
                        int pos = this.receivedPacketPos;
                        IDataPCM pcm = (IDataPCM)((Object)data);
                        byte[] audioData = pcm.getSamplePCMData();
                        int perTick = audioData.length * 50 / data.getTime();
                        int len = perTick;
                        if (pos + len > audioData.length) {
                            len = audioData.length - pos;
                        }
                        if (len > 0) {
                            byte[] targetData = new byte[len];
                            System.arraycopy(audioData, pos, targetData, 0, len);
                            this.receivedPacketPos += len;
                            byte[] preEncodeOutput = TapeResampler.toSigned8(targetData, pcm.getSampleSize() * 8, 1, pcm.isSampleBigEndian(), pcm.isSampleSigned(), pcm.getSampleRate(), 48000, false);
                            if (preEncodeOutput != null) {
                                if (this.recordDFPWM == null) {
                                    this.recordDFPWM = new DFPWM();
                                }
                                this.recordDFPWM.compress(dataOut, preEncodeOutput, 0, 0, Math.min(dataOut.length, preEncodeOutput.length / 8));
                            }
                        } else {
                            this.receivedPacketPos = audioData.length;
                        }
                    }
                    storage.write(dataOut);
                } else {
                    int offset = 3072 * (this.state == State.FORWARDING ? 1 : -1);
                    int len = storage.seek(offset);
                    if (len != offset) {
                        this.setState(State.STOPPED);
                    }
                }
                this.counter += storage.getPosition() - rel;
            }
            if (!found) {
                this.setState(State.STOPPED);
            }
        }
        if (this.lastState != this.state) {
            ModCharsetAudio.packet.sendToWatching((Packet)new PacketDriveState((IMultipart)this.owner, this.state), (IMultipart)this.owner);
            if (this.state == State.STOPPED && this.lastState == State.PLAYING && this.sourceId != null) {
                AudioUtils.stop(this.sourceId);
                this.sourceId = null;
            }
        }
        if (lastCounter != this.counter) {
            this.updateCounter();
        }
        this.lastState = this.state;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74774_a("st", (byte)this.state.ordinal());
        compound.func_74768_a("ct", this.counter);
        return compound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.state = State.STOPPED;
        if (nbt != null) {
            byte stateId;
            if (nbt.func_74764_b("st") && (stateId = nbt.func_74771_c("st")) >= 0 && stateId < State.values().length) {
                this.state = State.values()[stateId];
            }
            this.counter = nbt.func_74762_e("ct");
        }
    }

    public State getState() {
        return this.state;
    }

    public IDataStorage getStorage() {
        IDataStorage storage;
        ItemStack stack = this.inventory.func_70301_a(0);
        if (stack != null && stack.hasCapability(ModCharsetAudio.CAP_STORAGE, null) && (storage = (IDataStorage)stack.getCapability(ModCharsetAudio.CAP_STORAGE, null)) != null) {
            return storage;
        }
        return null;
    }

    public void updateCounter() {
        PacketDriveCounter packetDriveCounter = new PacketDriveCounter((IMultipart)this.owner, this.counter);
        for (EntityPlayer player : this.inventory.watchers) {
            ModCharsetAudio.packet.sendTo(packetDriveCounter, (EntityPlayerMP)player);
        }
    }

    @Override
    public boolean receive(AudioPacket packet) {
        if (this.state == State.RECORDING) {
            this.receivedPacket = packet;
            this.receivedPacketPos = 0;
            return true;
        }
        return false;
    }
}

