/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.audio.tape;

import java.util.ArrayList;
import java.util.List;
import mcmultipart.MCMultiPartMod;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.PartSlot;
import mcmultipart.raytrace.PartMOP;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import pl.asie.charset.api.audio.IAudioSource;
import pl.asie.charset.api.tape.IDataStorage;
import pl.asie.charset.audio.ModCharsetAudio;
import pl.asie.charset.audio.tape.ItemTape;
import pl.asie.charset.audio.tape.PacketDriveCounter;
import pl.asie.charset.audio.tape.PacketDriveState;
import pl.asie.charset.audio.tape.State;
import pl.asie.charset.audio.tape.TapeDriveState;
import pl.asie.charset.lib.Capabilities;
import pl.asie.charset.lib.Properties;
import pl.asie.charset.lib.inventory.IInventoryOwner;
import pl.asie.charset.lib.inventory.InventorySimple;
import pl.asie.charset.lib.multipart.PartSlab;
import pl.asie.charset.lib.network.Packet;
import pl.asie.charset.lib.utils.MachineSound;

public class PartTapeDrive
extends PartSlab
implements IAudioSource,
ITickable,
IInventoryOwner,
ICapabilityProvider {
    public final InventorySimple inventory = new InventorySimple(1, this){

        @Override
        public boolean func_94041_b(int index, ItemStack stack) {
            return stack == null || stack.func_77973_b() instanceof ItemTape;
        }
    };
    public final InvWrapper invWrapper = new InvWrapper((IInventory)this.inventory);
    protected EnumFacing facing = EnumFacing.NORTH;
    protected final TapeDriveState state = new TapeDriveState(this, this.inventory);
    @SideOnly(value=Side.CLIENT)
    private MachineSound sound;

    public ItemStack asItemStack() {
        return new ItemStack((Item)ModCharsetAudio.partTapeDriveItem);
    }

    public float getHardness(PartMOP hit) {
        return 3.0f;
    }

    public Material getMaterial() {
        return Material.field_151573_f;
    }

    public ItemStack getPickBlock(EntityPlayer player, PartMOP hit) {
        return this.asItemStack();
    }

    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(this.asItemStack());
        if (this.inventory.func_70301_a(0) != null) {
            list.add(this.inventory.func_70301_a(0));
        }
        return list;
    }

    public State getState() {
        return this.state.getState();
    }

    public void setState(State state) {
        this.state.setState(state);
    }

    public ResourceLocation getModelPath() {
        return new ResourceLocation("charsetaudio:tapedrive");
    }

    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack stack, PartMOP hit) {
        player.openGui((Object)ModCharsetAudio.instance, this.isTop ? PartSlot.UP.ordinal() : PartSlot.DOWN.ordinal(), this.getWorld(), this.getPos().func_177958_n(), this.getPos().func_177956_o(), this.getPos().func_177952_p());
        if (!player.field_70170_p.field_72995_K) {
            ModCharsetAudio.packet.sendToWatching((Packet)new PacketDriveState((IMultipart)this, this.getState()), (IMultipart)this);
        }
        if (player instanceof EntityPlayerMP) {
            ModCharsetAudio.packet.sendTo(new PacketDriveCounter((IMultipart)this, this.state.counter), (EntityPlayerMP)player);
        }
        return true;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        this.inventory.writeToNBT(nbt, "items");
        nbt.func_74774_a("facing", (byte)this.facing.ordinal());
        NBTTagCompound stateNbt = this.state.serializeNBT();
        nbt.func_74782_a("state", (NBTBase)stateNbt);
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.inventory.readFromNBT(nbt, "items");
        this.state.deserializeNBT(nbt.func_74775_l("state"));
        if (nbt.func_74764_b("facing")) {
            this.facing = EnumFacing.func_82600_a((int)nbt.func_74771_c("facing"));
            if (this.facing == null || this.facing.func_176740_k() == EnumFacing.Axis.Y) {
                this.facing = EnumFacing.NORTH;
            }
        } else {
            this.facing = EnumFacing.NORTH;
        }
    }

    @Override
    public void writeUpdatePacket(PacketBuffer buf) {
        super.writeUpdatePacket(buf);
        buf.writeByte(this.facing.ordinal());
    }

    @Override
    public void readUpdatePacket(PacketBuffer buf) {
        super.readUpdatePacket(buf);
        this.facing = EnumFacing.func_82600_a((int)buf.readByte());
    }

    public IBlockState getActualState(IBlockState state) {
        return state.func_177226_a((IProperty)PartSlab.IS_TOP, (Comparable)Boolean.valueOf(this.isTop())).func_177226_a((IProperty)Properties.FACING4, (Comparable)this.facing);
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)MCMultiPartMod.multipart, new IProperty[]{PartSlab.IS_TOP, Properties.FACING4});
    }

    public void func_73660_a() {
        if (this.getWorld() != null) {
            if (!this.getWorld().field_72995_K) {
                this.state.func_73660_a();
            } else {
                this.updateSound();
            }
        }
    }

    @Override
    public void onInventoryChanged(IInventory inventory) {
        this.markDirty();
    }

    public void writeData(byte[] data, boolean isLast, int totalLength) {
        IDataStorage storage = this.state.getStorage();
        if (storage != null) {
            this.setState(State.STOPPED);
            storage.write(data);
            if (isLast) {
                storage.seek(-totalLength);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void updateSound() {
        boolean isLooping;
        boolean bl = isLooping = this.getState() == State.REWINDING || this.getState() == State.FORWARDING;
        if (isLooping && this.sound == null) {
            this.sound = new MachineSound(new ResourceLocation("charsetaudio", "tape_rewind"), SoundCategory.BLOCKS, (float)this.getPos().func_177958_n() + 0.5f, (float)this.getPos().func_177956_o() + (this.isTop() ? 0.75f : 0.25f), (float)this.getPos().func_177952_p() + 0.5f, 1.0f, 1.0f);
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.sound);
        } else if (!isLooping && this.sound != null) {
            this.sound.endPlaying();
            Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)this.sound);
            this.sound = null;
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == Capabilities.AUDIO_SOURCE || capability == Capabilities.AUDIO_RECEIVER;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.invWrapper);
        }
        if (capability == Capabilities.AUDIO_SOURCE) {
            return (T)Capabilities.AUDIO_SOURCE.cast((Object)this);
        }
        if (capability == Capabilities.AUDIO_RECEIVER) {
            return (T)Capabilities.AUDIO_RECEIVER.cast((Object)this.state);
        }
        return null;
    }
}

