/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.audio.recipe;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import pl.asie.charset.audio.ModCharsetAudio;
import pl.asie.charset.audio.tape.ItemTape;
import pl.asie.charset.lib.recipe.RecipeBase;

public class RecipeTape
extends RecipeBase {
    private static final String TAPE_PATTERN = "mmmr rsss";

    private ItemTape.Material getMaterial(ItemStack source, ItemTape.Material previous) {
        int[] oreIds = OreDictionary.getOreIDs((ItemStack)source);
        if (previous != null) {
            int oreId = OreDictionary.getOreID((String)previous.oreDict);
            for (int j : oreIds) {
                if (oreId != j) continue;
                return previous;
            }
        } else {
            for (ItemTape.Material m : ItemTape.Material.values()) {
                int oreId = OreDictionary.getOreID((String)m.oreDict);
                for (int j : oreIds) {
                    if (oreId != j) continue;
                    return m;
                }
            }
        }
        return null;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        ItemTape.Material material = null;
        block6: for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack source = inv.func_70301_a(i);
            switch (TAPE_PATTERN.charAt(i)) {
                case ' ': {
                    if (source == null) continue block6;
                    return false;
                }
                case 'm': {
                    if (source == null) {
                        return false;
                    }
                    ItemTape.Material newMaterial = this.getMaterial(source, material);
                    if (newMaterial == null) {
                        return false;
                    }
                    material = newMaterial;
                    continue block6;
                }
                case 'r': {
                    if (source != null && source.func_77973_b() == ModCharsetAudio.tapeReelItem) continue block6;
                    return false;
                }
                case 's': {
                    if (source != null && source.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150333_U)) continue block6;
                    return false;
                }
            }
        }
        return true;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        ItemTape.Material material = null;
        int totalTapeItems = 0;
        block4: for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack source = inv.func_70301_a(i);
            switch (TAPE_PATTERN.charAt(i)) {
                case 'm': {
                    ItemTape.Material newMaterial = this.getMaterial(source, material);
                    if (newMaterial == null) {
                        return null;
                    }
                    material = newMaterial;
                    continue block4;
                }
                case 'r': {
                    totalTapeItems += source.func_77952_i();
                }
            }
        }
        if (material != null && totalTapeItems > 0) {
            int size = totalTapeItems * 15 * 48000 / 8;
            return ItemTape.asItemStack(size, material);
        }
        return null;
    }

    public ItemStack func_77571_b() {
        return null;
    }
}

