/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.util.serialization;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.whammich.sstow.shade.lib.util.BlockStack;
import java.lang.reflect.Type;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class SerializerBlockStack
implements JsonDeserializer<BlockStack>,
JsonSerializer<BlockStack> {
    public BlockStack deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String name = json.getAsJsonObject().get("name").getAsString();
        int meta = 0;
        if (json.getAsJsonObject().get("meta") != null) {
            meta = json.getAsJsonObject().get("meta").getAsInt();
        }
        return new BlockStack((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(name)), meta);
    }

    public JsonElement serialize(BlockStack src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", src.getBlock().getRegistryName().toString());
        if (src.getMeta() != 0) {
            jsonObject.addProperty("meta", (Number)src.getMeta());
        }
        return jsonObject;
    }
}

