/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.tile;

import com.whammich.sstow.shade.lib.util.helper.TextHelper;
import com.whammich.sstow.util.Utils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileInventory
extends TileEntity
implements IInventory {
    protected int[] syncedSlots = new int[0];
    private ItemStack[] inventory;
    private int size;
    private String name;
    private IItemHandler handler;
    private IItemHandler handlerUp;
    private IItemHandler handlerDown;
    private IItemHandler handlerNorth;
    private IItemHandler handlerSouth;
    private IItemHandler handlerEast;
    private IItemHandler handlerWest;

    public TileInventory(int size, String name) {
        this.inventory = new ItemStack[size];
        this.size = size;
        this.name = name;
        this.setItemHandlers();
    }

    private boolean isSyncedSlot(int slot) {
        for (int s : this.syncedSlots) {
            if (s != slot) continue;
            return true;
        }
        return false;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        NBTTagList tags = tagCompound.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tags.func_74745_c(); ++i) {
            NBTTagCompound data;
            byte j;
            if (this.isSyncedSlot(i) || (j = (data = tags.func_150305_b(i)).func_74771_c("Slot")) < 0 || j >= this.inventory.length) continue;
            this.inventory[j] = ItemStack.func_77949_a((NBTTagCompound)data);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        NBTTagList tags = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null || this.isSyncedSlot(i)) continue;
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(data);
            tags.func_74742_a((NBTBase)data);
        }
        tagCompound.func_74782_a("Items", (NBTBase)tags);
        return tagCompound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_189515_b(nbt);
        return new SPacketUpdateTileEntity(this.func_174877_v(), -999, nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void dropItems() {
        InventoryHelper.func_180175_a((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (IInventory)this);
    }

    public boolean insertItem(EntityPlayer player, EnumHand hand, int slot) {
        if (this.func_70301_a(slot) == null && player.func_184586_b(hand) != null && this.func_94041_b(slot, player.func_184586_b(hand))) {
            ItemStack input = player.func_184586_b(hand).func_77946_l();
            input.field_77994_a = 1;
            --player.func_184586_b((EnumHand)hand).field_77994_a;
            this.func_70299_a(slot, input);
            return true;
        }
        if (this.func_70301_a(slot) != null && player.func_184586_b(hand) == null) {
            if (!this.func_145831_w().field_72995_K) {
                EntityItem invItem = new EntityItem(this.func_145831_w(), player.field_70165_t, player.field_70163_u + 0.25, player.field_70161_v, this.func_70301_a(slot));
                this.func_145831_w().func_72838_d((Entity)invItem);
            }
            this.func_174888_l();
            return false;
        }
        return false;
    }

    protected void setItemHandlers() {
        if (this instanceof ISidedInventory) {
            this.handlerUp = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
            this.handlerDown = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
            this.handlerNorth = new SidedInvWrapper((ISidedInventory)this, EnumFacing.NORTH);
            this.handlerSouth = new SidedInvWrapper((ISidedInventory)this, EnumFacing.SOUTH);
            this.handlerEast = new SidedInvWrapper((ISidedInventory)this, EnumFacing.EAST);
            this.handlerWest = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);
        } else {
            this.handler = new InvWrapper((IInventory)this);
        }
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this instanceof ISidedInventory && facing != null) {
                switch (facing) {
                    case UP: {
                        return (T)this.handlerUp;
                    }
                    case DOWN: {
                        return (T)this.handlerDown;
                    }
                    case NORTH: {
                        return (T)this.handlerNorth;
                    }
                    case SOUTH: {
                        return (T)this.handlerSouth;
                    }
                    case EAST: {
                        return (T)this.handlerEast;
                    }
                    case WEST: {
                        return (T)this.handlerWest;
                    }
                }
            } else {
                return (T)this.handler;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    public int func_70302_i_() {
        return this.size;
    }

    public ItemStack func_70301_a(int index) {
        return this.inventory[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.inventory[index] != null) {
            if (!this.func_145831_w().field_72995_K) {
                Utils.notifyUpdateBasic(this.func_145831_w(), this.func_174877_v());
            }
            if (this.inventory[index].field_77994_a <= count) {
                ItemStack itemStack = this.inventory[index];
                this.inventory[index] = null;
                this.func_70296_d();
                return itemStack;
            }
            ItemStack itemStack = this.inventory[index].func_77979_a(count);
            if (this.inventory[index].field_77994_a == 0) {
                this.inventory[index] = null;
            }
            this.func_70296_d();
            return itemStack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventory[slot] != null) {
            ItemStack itemStack = this.inventory[slot];
            this.func_70299_a(slot, null);
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
        if (!this.func_145831_w().field_72995_K) {
            Utils.notifyUpdateBasic(this.func_145831_w(), this.func_174877_v());
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory = new ItemStack[this.size];
    }

    public String func_70005_c_() {
        return TextHelper.localize("tile.SoulShardsTOW." + this.name + ".name", new Object[0]);
    }

    public boolean func_145818_k_() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }
}

