/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.shade.lib.util.helper;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class InventoryHelper {
    public static IItemHandler getItemHandler(TileEntity tile, EnumFacing side) {
        IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        if (handler == null) {
            if (side != null && tile instanceof ISidedInventory) {
                handler = new SidedInvWrapper((ISidedInventory)tile, side);
            } else if (tile instanceof IInventory) {
                handler = new InvWrapper((IInventory)tile);
            }
        }
        return handler;
    }

    public static ItemStack insertStack(TileEntity tile, ItemStack stack) {
        return InventoryHelper.insertStack(tile, stack, null);
    }

    public static ItemStack insertStack(TileEntity tile, ItemStack stack, EnumFacing facing) {
        IItemHandler handler = InventoryHelper.getItemHandler(tile, facing);
        return InventoryHelper.insertStack(handler, stack);
    }

    public static ItemStack insertStack(IItemHandler itemHandler, ItemStack stack) {
        ItemStack copy = stack.func_77946_l();
        for (int i = 0; i < itemHandler.getSlots(); ++i) {
            if ((copy = itemHandler.insertItem(i, copy, false)) != null) continue;
            return null;
        }
        return copy;
    }

    public static boolean dropRemainderAtBlock(World world, BlockPos pos, @Nullable EnumFacing pushDirection, ItemStack stack) {
        if (world.field_72995_K) {
            return false;
        }
        EntityItem entityItem = new EntityItem(world);
        BlockPos spawnPos = new BlockPos((Vec3i)pos);
        double velocity = 0.15;
        if (pushDirection != null) {
            spawnPos.func_177972_a(pushDirection);
            switch (pushDirection) {
                case DOWN: {
                    entityItem.field_70181_x = -velocity;
                    entityItem.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() - 1.0, (double)spawnPos.func_177952_p() + 0.5);
                    break;
                }
                case UP: {
                    entityItem.field_70181_x = velocity;
                    entityItem.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 1.0, (double)spawnPos.func_177952_p() + 0.5);
                    break;
                }
                case NORTH: {
                    entityItem.field_70179_y = -velocity;
                    entityItem.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 0.5, (double)spawnPos.func_177952_p() - 1.0);
                    break;
                }
                case SOUTH: {
                    entityItem.field_70179_y = velocity;
                    entityItem.func_70107_b((double)spawnPos.func_177958_n() + 0.5, (double)spawnPos.func_177956_o() + 0.5, (double)spawnPos.func_177952_p() + 1.0);
                    break;
                }
                case WEST: {
                    entityItem.field_70159_w = -velocity;
                    entityItem.func_70107_b((double)spawnPos.func_177958_n() - 1.0, (double)spawnPos.func_177956_o() + 0.5, (double)spawnPos.func_177952_p() + 0.5);
                    break;
                }
                case EAST: {
                    entityItem.field_70159_w = velocity;
                    entityItem.func_70107_b((double)spawnPos.func_177958_n() + 1.0, (double)spawnPos.func_177956_o() + 0.5, (double)spawnPos.func_177952_p() + 0.5);
                }
            }
        }
        entityItem.func_92058_a(stack);
        return world.func_72838_d((Entity)entityItem);
    }
}

