/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.shade.lib.translate;

import com.whammich.sstow.shade.lib.LendingLibrary;
import com.whammich.sstow.shade.lib.translate.MessageLocalization;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LocalizationHelper {
    public static final List<LocalizationHelper> localizationHelpers = new ArrayList<LocalizationHelper>();
    private final List<String> keys;
    private final int deletionId;
    private final SimpleNetworkWrapper networkWrapper;

    public LocalizationHelper(SimpleNetworkWrapper networkWrapper, int id) {
        this(networkWrapper, id, new Random().nextInt());
    }

    public LocalizationHelper(SimpleNetworkWrapper networkWrapper, int id, int deletionId) {
        networkWrapper.registerMessage(MessageLocalization.Handler.class, MessageLocalization.class, id, Side.CLIENT);
        this.networkWrapper = networkWrapper;
        this.deletionId = deletionId;
        this.keys = new ArrayList<String>();
        localizationHelpers.add(this);
    }

    @SideOnly(value=Side.CLIENT)
    public ITextComponent localize(String key, Object ... format) {
        if (!this.keys.contains(key)) {
            this.keys.add(key);
        }
        return new TextComponentString(I18n.func_135052_a((String)key, (Object[])format));
    }

    @SideOnly(value=Side.CLIENT)
    public String getText(String key, Object ... format) {
        return this.localize(key, format).func_150254_d();
    }

    protected int getKeyId(String key) {
        if (!this.keys.contains(key)) {
            this.keys.add(key);
        }
        return this.keys.indexOf(key);
    }

    public void sendLocalization(EntityPlayerMP player, String key, Object ... format) {
        LendingLibrary.getModLogger().debug("Sent key [{}] to client {} [{}].", key, player.func_70005_c_(), player.func_146103_bH().getId());
        this.networkWrapper.sendTo((IMessage)new MessageLocalization(localizationHelpers.indexOf(this), key, format), player);
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public int getDeletionId() {
        return this.deletionId;
    }
}

