/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.shade.lib.teleport;

import com.whammich.sstow.shade.lib.teleport.Teleport;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateHealth;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class Teleports {

    public static class DifferentDim
    extends Teleport {
        private World oldWorld;
        private int newWorldID;

        public DifferentDim(BlockPos pos, Entity entity, World oldWorld, int newWorldID) {
            super(pos, entity);
            this.oldWorld = oldWorld;
            this.newWorldID = newWorldID;
        }

        public DifferentDim(int x, int y, int z, Entity entity, World oldWorld, int newWorldID) {
            super(x, y, z, entity);
            this.oldWorld = oldWorld;
            this.newWorldID = newWorldID;
        }

        @Override
        public void teleport() {
            if (this.getEntity() != null && this.getEntity().field_71088_bW <= 0) {
                MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
                WorldServer oldWorldServer = server.func_71218_a(this.getEntity().field_71093_bK);
                WorldServer newWorldServer = server.func_71218_a(this.newWorldID);
                if (this.getEntity() instanceof EntityPlayer) {
                    EntityPlayerMP player = (EntityPlayerMP)this.getEntity();
                    if (!player.field_70170_p.field_72995_K) {
                        player.func_184204_a(this.newWorldID);
                        player.func_70634_a((double)this.getPos().func_177958_n() + 0.5, (double)this.getPos().func_177956_o() + 0.5, (double)this.getPos().func_177952_p() + 0.5);
                        player.field_70170_p.func_72866_a((Entity)player, false);
                        player.field_71135_a.func_147359_a((Packet)new SPacketUpdateHealth(player.func_110143_aJ(), player.func_71024_bL().func_75116_a(), player.func_71024_bL().func_75115_e()));
                    }
                    this.getEntity().field_70170_p.func_184134_a((double)this.getPos().func_177958_n(), (double)this.getPos().func_177956_o(), (double)this.getPos().func_177952_p(), SoundEvents.field_187534_aX, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
                } else if (!this.getEntity().field_70170_p.field_72995_K) {
                    NBTTagCompound tag = new NBTTagCompound();
                    this.getEntity().func_70039_c(tag);
                    this.getEntity().func_70106_y();
                    this.oldWorld.func_184134_a(this.getEntity().field_70165_t, this.getEntity().field_70163_u, this.getEntity().field_70161_v, SoundEvents.field_187534_aX, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
                    Entity teleportedEntity = EntityList.func_75615_a((NBTTagCompound)tag, (World)newWorldServer);
                    if (teleportedEntity != null) {
                        teleportedEntity.func_70012_b((double)this.getPos().func_177958_n() + 0.5, (double)this.getPos().func_177956_o() + 0.5, (double)this.getPos().func_177952_p() + 0.5, this.getEntity().field_70177_z, this.getEntity().field_70125_A);
                        teleportedEntity.field_98038_p = true;
                        newWorldServer.func_72838_d(teleportedEntity);
                        teleportedEntity.func_70029_a((World)newWorldServer);
                        teleportedEntity.field_71088_bW = teleportedEntity instanceof EntityPlayer ? 150 : 20;
                    }
                    oldWorldServer.func_82742_i();
                    newWorldServer.func_82742_i();
                }
                this.getEntity().field_71088_bW = this.getEntity() instanceof EntityLiving ? 150 : 20;
                this.getEntity().field_70170_p.func_184134_a((double)this.getPos().func_177958_n(), (double)this.getPos().func_177956_o(), (double)this.getPos().func_177952_p(), SoundEvents.field_187534_aX, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
            }
        }

        public World getOldWorld() {
            return this.oldWorld;
        }

        public int getNewWorldID() {
            return this.newWorldID;
        }
    }

    public static class SameDim
    extends Teleport {
        public SameDim(BlockPos pos, Entity entity) {
            super(pos, entity);
        }

        public SameDim(int x, int y, int z, Entity entity) {
            super(x, y, z, entity);
        }

        @Override
        public void teleport() {
            if (this.getEntity() != null && this.getEntity().field_71088_bW <= 0) {
                if (this.getEntity() instanceof EntityPlayer) {
                    EntityPlayerMP player = (EntityPlayerMP)this.getEntity();
                    player.func_70634_a((double)this.getPos().func_177958_n() + 0.5, (double)this.getPos().func_177956_o() + 0.5, (double)this.getPos().func_177952_p() + 0.5);
                    player.field_70170_p.func_72866_a((Entity)player, false);
                    player.field_71135_a.func_147359_a((Packet)new SPacketUpdateHealth(player.func_110143_aJ(), player.func_71024_bL().func_75116_a(), player.func_71024_bL().func_75115_e()));
                    player.field_71088_bW = 150;
                    player.field_70170_p.func_184134_a((double)this.getPos().func_177958_n(), (double)this.getPos().func_177956_o(), (double)this.getPos().func_177952_p(), SoundEvents.field_187534_aX, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
                } else {
                    WorldServer world = (WorldServer)this.getEntity().field_70170_p;
                    this.getEntity().func_70107_b((double)this.getPos().func_177958_n() + 0.5, (double)this.getPos().func_177956_o() + 0.5, (double)this.getPos().func_177952_p() + 0.5);
                    this.getEntity().field_71088_bW = 150;
                    world.func_82742_i();
                    this.getEntity().field_70170_p.func_184134_a((double)this.getPos().func_177958_n(), (double)this.getPos().func_177956_o(), (double)this.getPos().func_177952_p(), SoundEvents.field_187534_aX, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
                }
            }
        }
    }
}

