/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.shade.lib.json.serialization;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import com.whammich.sstow.shade.lib.json.serialization.SerializerBase;
import java.lang.reflect.Type;
import org.apache.commons.lang3.tuple.Pair;

public class SerializerPair<L, R>
extends SerializerBase<Pair<L, R>> {
    public static final String LEFT = "left";
    public static final String RIGHT = "right";

    @Override
    public Pair<L, R> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonElement left = json.getAsJsonObject().get(LEFT);
        JsonElement right = json.getAsJsonObject().get(RIGHT);
        return Pair.of((Object)left, (Object)right);
    }

    @Override
    public JsonElement serialize(Pair<L, R> src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(LEFT, context.serialize(src.getLeft(), new TypeToken<L>(){}.getType()));
        jsonObject.add(RIGHT, context.serialize(src.getRight(), new TypeToken<R>(){}.getType()));
        return jsonObject;
    }

    @Override
    public Class<?> getType() {
        return Pair.class;
    }
}

