/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.shade.lib.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.whammich.sstow.shade.lib.LendingLibrary;
import com.whammich.sstow.shade.lib.json.serialization.SerializerBase;
import com.whammich.sstow.shade.lib.json.serialization.SerializerBlockPos;
import com.whammich.sstow.shade.lib.json.serialization.SerializerBlockStack;
import com.whammich.sstow.shade.lib.json.serialization.SerializerItemStack;
import com.whammich.sstow.shade.lib.util.BlockStack;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;

public class JsonHelper {
    public static Gson gson;

    public static void setGson(boolean offset, boolean nbt) {
        gson = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().registerTypeAdapter(BlockPos.class, (Object)new SerializerBlockPos(offset)).registerTypeAdapter(ItemStack.class, (Object)new SerializerItemStack(nbt)).registerTypeAdapter(BlockStack.class, (Object)new SerializerBlockStack()).create();
    }

    public static void setGson(SerializerBase ... serializers) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.disableHtmlEscaping();
        gsonBuilder.serializeNulls();
        gsonBuilder.setPrettyPrinting();
        for (SerializerBase serializer : serializers) {
            gsonBuilder.registerTypeAdapter(serializer.getType(), (Object)serializer);
        }
        gson = gsonBuilder.create();
    }

    public static void setGson(Gson newGson) {
        gson = newGson;
    }

    public static <T> boolean tryCreateDefault(File jsonFile, Object def) {
        try {
            if (!jsonFile.exists() && jsonFile.createNewFile()) {
                String json = gson.toJson(def, new TypeToken<T>(){}.getType());
                FileWriter fileWriter = new FileWriter(jsonFile);
                fileWriter.write(json);
                fileWriter.close();
                return true;
            }
        }
        catch (IOException e) {
            LendingLibrary.getLogger().error("Error handling JSON file {}", jsonFile.toString());
        }
        return false;
    }

    @Nullable
    public static <T> T fromJson(File jsonFile, Class<T> clazz) {
        try {
            return (T)gson.fromJson((Reader)new FileReader(jsonFile), clazz);
        }
        catch (FileNotFoundException e) {
            LendingLibrary.getLogger().error(e.getLocalizedMessage(), new Object[0]);
            return null;
        }
    }

    @Nullable
    public static <T> T fromJson(File jsonFile, Type type) {
        try {
            return (T)gson.fromJson((Reader)new FileReader(jsonFile), type);
        }
        catch (FileNotFoundException e) {
            LendingLibrary.getLogger().error(e.getLocalizedMessage(), new Object[0]);
            return null;
        }
    }

    public static boolean getBoolean(JsonElement jsonElement, String memberName, boolean def) {
        if (!jsonElement.getAsJsonObject().has(memberName)) {
            return def;
        }
        return jsonElement.getAsJsonObject().get(memberName).getAsBoolean();
    }

    public static String getString(JsonElement jsonElement, String memberName, String def) {
        if (!jsonElement.getAsJsonObject().has(memberName)) {
            return def;
        }
        return jsonElement.getAsJsonObject().get(memberName).getAsString();
    }

    public static char getCharacter(JsonElement jsonElement, String memberName, char def) {
        if (!jsonElement.getAsJsonObject().has(memberName)) {
            return def;
        }
        return jsonElement.getAsJsonObject().get(memberName).getAsCharacter();
    }

    public static int getInteger(JsonElement jsonElement, String memberName, int def) {
        if (!jsonElement.getAsJsonObject().has(memberName)) {
            return def;
        }
        return jsonElement.getAsJsonObject().get(memberName).getAsInt();
    }

    public static short getShort(JsonElement jsonElement, String memberName, short def) {
        if (!jsonElement.getAsJsonObject().has(memberName)) {
            return def;
        }
        return jsonElement.getAsJsonObject().get(memberName).getAsShort();
    }

    public static long getLong(JsonElement jsonElement, String memberName, long def) {
        if (!jsonElement.getAsJsonObject().has(memberName)) {
            return def;
        }
        return jsonElement.getAsJsonObject().get(memberName).getAsLong();
    }

    public static double getDouble(JsonElement jsonElement, String memberName, double def) {
        if (!jsonElement.getAsJsonObject().has(memberName)) {
            return def;
        }
        return jsonElement.getAsJsonObject().get(memberName).getAsDouble();
    }

    public static float getFloat(JsonElement jsonElement, String memberName, float def) {
        if (!jsonElement.getAsJsonObject().has(memberName)) {
            return def;
        }
        return jsonElement.getAsJsonObject().get(memberName).getAsFloat();
    }

    public static Color getColor(JsonElement jsonElement, String memberName, Color def) {
        return JsonHelper.getColor(jsonElement, memberName, "#" + def.getRGB());
    }

    public static Color getColor(JsonElement jsonElement, String memberName, String def) {
        if (!def.startsWith("#")) {
            def = "#" + def;
        }
        if (!jsonElement.getAsJsonObject().has(memberName)) {
            return Color.decode(def);
        }
        String ret = jsonElement.getAsJsonObject().get(memberName).getAsString();
        if (!ret.startsWith("#")) {
            ret = "#" + ret;
        }
        return Color.decode(ret);
    }

    static {
        JsonHelper.setGson(false, false);
    }
}

