/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.shade.lib.impl;

import com.whammich.sstow.shade.lib.LendingLibrary;
import com.whammich.sstow.shade.lib.annot.ModBlock;
import com.whammich.sstow.shade.lib.annot.ModItem;
import com.whammich.sstow.shade.lib.util.helper.BlockHelper;
import com.whammich.sstow.shade.lib.util.helper.ItemHelper;
import java.lang.reflect.Constructor;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;

public class ObjectHandler {
    static void registerBlocks(Side side) {
        for (ASMDataTable.ASMData data : LendingLibrary.getInstance().getModBlocks()) {
            try {
                Item modItemBlock;
                Class<?> asmClass = Class.forName(data.getClassName());
                Class<Block> modBlockClass = asmClass.asSubclass(Block.class);
                String name = modBlockClass.getAnnotation(ModBlock.class).name();
                Class<? extends TileEntity> tileClass = modBlockClass.getAnnotation(ModBlock.class).tileEntity();
                Class<? extends ItemBlock> itemBlockClass = modBlockClass.getAnnotation(ModBlock.class).itemBlock();
                Constructor<? extends ItemBlock> itemBlockConstructor = itemBlockClass.getDeclaredConstructor(Block.class);
                Block modBlock = modBlockClass.newInstance();
                if (modBlock.getRegistryName() == null) {
                    modBlock.setRegistryName(name);
                }
                if ((modItemBlock = (Item)itemBlockConstructor.newInstance(modBlock)).getRegistryName() == null) {
                    modItemBlock.setRegistryName(modBlock.getRegistryName());
                }
                GameRegistry.register((IForgeRegistryEntry)modBlock);
                GameRegistry.register((IForgeRegistryEntry)modItemBlock);
                if (tileClass != TileEntity.class) {
                    GameRegistry.registerTileEntity(tileClass, (String)(LendingLibrary.getMODID() + ":" + tileClass.getSimpleName()));
                }
                if (side == Side.CLIENT) {
                    LendingLibrary.getInstance().getClientHandler().tryHandleBlockModel(modBlock, name);
                }
                BlockHelper.blockClassToName.put(modBlockClass, name);
            }
            catch (Exception e) {
                LendingLibrary.getLogger().error("Unable to register block for class {}", data.getClassName());
                LendingLibrary.getLogger().error(e.getMessage(), new Object[0]);
            }
        }
    }

    static void registerItems(Side side) {
        for (ASMDataTable.ASMData data : LendingLibrary.getInstance().getModItems()) {
            try {
                Class<?> asmClass = Class.forName(data.getClassName());
                Class<Item> modItemClass = asmClass.asSubclass(Item.class);
                String name = modItemClass.getAnnotation(ModItem.class).name();
                Item modItem = modItemClass.newInstance();
                if (modItem.getRegistryName() == null) {
                    modItem.setRegistryName(name);
                }
                GameRegistry.register((IForgeRegistryEntry)modItem);
                if (side == Side.CLIENT) {
                    LendingLibrary.getInstance().getClientHandler().tryHandleItemModel(modItem, name);
                }
                ItemHelper.itemClassToName.put(modItemClass, name);
            }
            catch (Exception e) {
                LendingLibrary.getLogger().error("Unable to register item for class {}", data.getClassName());
            }
        }
    }
}

