/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.shade.lib.impl;

import com.whammich.sstow.shade.lib.LendingLibrary;
import com.whammich.sstow.shade.lib.annot.Handler;
import com.whammich.sstow.shade.lib.iface.IProxy;
import com.whammich.sstow.shade.lib.impl.ObjectHandler;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class CommonHandler
implements IProxy {
    @Override
    public void preInit(FMLPreInitializationEvent event) {
        for (ASMDataTable.ASMData data : LendingLibrary.getInstance().getModHandlers()) {
            try {
                Class<?> asmClass = Class.forName(data.getClassName());
                boolean client = asmClass.getAnnotation(Handler.class).client();
                Object handler = asmClass.newInstance();
                if (client) continue;
                MinecraftForge.EVENT_BUS.register(handler);
            }
            catch (Exception e) {
                LendingLibrary.getLogger().error("Unable to register event handler for class {}", data.getClassName());
            }
        }
        ObjectHandler.registerBlocks(event.getSide());
        ObjectHandler.registerItems(event.getSide());
    }

    @Override
    public void init(FMLInitializationEvent event) {
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
    }

    public void tryHandleBlockModel(Block block, String name) {
    }

    public void tryHandleItemModel(Item item, String name) {
    }
}

