/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.shade.lib;

import com.whammich.sstow.shade.lib.annot.Handler;
import com.whammich.sstow.shade.lib.annot.ModBlock;
import com.whammich.sstow.shade.lib.annot.ModItem;
import com.whammich.sstow.shade.lib.impl.ClientHandler;
import com.whammich.sstow.shade.lib.impl.CommonHandler;
import com.whammich.sstow.shade.lib.util.helper.LogHelper;
import java.util.Set;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;

public class LendingLibrary {
    private static final LogHelper logger = new LogHelper("LendingLibrary");
    private static LogHelper modLogger;
    private static LendingLibrary instance;
    private static String MODID;
    private Set<ASMDataTable.ASMData> modBlocks;
    private Set<ASMDataTable.ASMData> modItems;
    private Set<ASMDataTable.ASMData> modHandlers;
    private CommonHandler commonHandler;
    private ClientHandler clientHandler;

    public LendingLibrary(String modid) {
        instance = this;
        MODID = modid;
        modLogger = new LogHelper(modid);
    }

    public void registerObjects(FMLPreInitializationEvent event) {
        this.modBlocks = event.getAsmData().getAll(ModBlock.class.getCanonicalName());
        this.modItems = event.getAsmData().getAll(ModItem.class.getCanonicalName());
        this.modHandlers = event.getAsmData().getAll(Handler.class.getCanonicalName());
        this.commonHandler = new CommonHandler();
        this.clientHandler = new ClientHandler();
        this.commonHandler.preInit(event);
        if (event.getSide() == Side.CLIENT) {
            this.clientHandler.preInit(event);
        }
    }

    public Set<ASMDataTable.ASMData> getModBlocks() {
        return this.modBlocks;
    }

    public Set<ASMDataTable.ASMData> getModItems() {
        return this.modItems;
    }

    public Set<ASMDataTable.ASMData> getModHandlers() {
        return this.modHandlers;
    }

    public CommonHandler getCommonHandler() {
        return this.commonHandler;
    }

    public ClientHandler getClientHandler() {
        return this.clientHandler;
    }

    public static LendingLibrary getInstance() {
        return instance;
    }

    public static String getMODID() {
        return MODID;
    }

    public static LogHelper getLogger() {
        return logger;
    }

    public static LogHelper getModLogger() {
        return modLogger;
    }
}

