/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow.block;

import com.whammich.sstow.SoulShardsTOW;
import com.whammich.sstow.api.ISoulCage;
import com.whammich.sstow.api.ShardHelper;
import com.whammich.sstow.api.SoulShardsAPI;
import com.whammich.sstow.shade.lib.annot.Handler;
import com.whammich.sstow.shade.lib.annot.ModBlock;
import com.whammich.sstow.shade.lib.iface.IVariantProvider;
import com.whammich.sstow.tile.TileEntityCage;
import com.whammich.sstow.util.TierHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.tuple.Pair;

@ModBlock(name="BlockCage", tileEntity=TileEntityCage.class)
@Handler
public class BlockCage
extends Block
implements IVariantProvider {
    public BlockCage() {
        super(Material.field_151573_f);
        this.func_149663_c("soulshardstow.cage");
        this.func_149647_a(SoulShardsTOW.soulShardsTab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)SoulShardsAPI.ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(3.0f);
        this.func_149752_b(3.0f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SoulShardsAPI.ACTIVE});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        return state.func_177226_a((IProperty)SoulShardsAPI.ACTIVE, (Comparable)Boolean.valueOf(((TileEntityCage)tile).getActiveState()));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)SoulShardsAPI.ACTIVE) != false ? 1 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)SoulShardsAPI.ACTIVE, (Comparable)Boolean.valueOf(BooleanUtils.toBoolean((int)MathHelper.func_76125_a((int)meta, (int)0, (int)1))));
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        TileEntityCage tile = (TileEntityCage)world.func_175625_s(pos);
        return (int)((float)tile.getTier() / (float)TierHandler.maxTier) * 15;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public void func_180663_b(World world, BlockPos blockPos, IBlockState blockState) {
        TileEntityCage tileCage = (TileEntityCage)world.func_175625_s(blockPos);
        if (tileCage != null) {
            tileCage.dropItems();
        }
        super.func_180663_b(world, blockPos, blockState);
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176214_u() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityCage();
    }

    @Override
    public List<Pair<Integer, String>> getVariants() {
        ArrayList<Pair<Integer, String>> ret = new ArrayList<Pair<Integer, String>>();
        ret.add(Pair.of((Object)0, (Object)"active=false"));
        ret.add(Pair.of((Object)1, (Object)"active=true"));
        return ret;
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        TileEntity tile = event.getWorld().func_175625_s(event.getPos());
        EntityPlayer player = event.getEntityPlayer();
        ItemStack heldItem = event.getItemStack();
        if (tile != null && tile instanceof ISoulCage) {
            TileEntityCage cage = (TileEntityCage)tile;
            if (heldItem != null && cage.func_70301_a(0) == null && cage.func_94041_b(0, heldItem) && !player.func_70093_af()) {
                cage.func_70299_a(0, heldItem.func_77946_l());
                cage.setTier(ShardHelper.getTierFromShard(heldItem));
                cage.setEntName(ShardHelper.getBoundEntity(heldItem));
                if (!event.getWorld().field_72995_K) {
                    cage.setOwner(player.func_146103_bH().getId().toString());
                }
                player.func_184611_a(event.getHand(), null);
                player.func_184609_a(event.getHand());
            } else if (cage.func_70301_a(0) != null && player.func_184614_ca() == null && player.func_70093_af()) {
                if (!event.getWorld().field_72995_K) {
                    EntityItem invItem = new EntityItem(event.getWorld(), player.field_70165_t, player.field_70163_u + 0.25, player.field_70161_v, cage.func_70301_a(0));
                    event.getWorld().func_72838_d((Entity)invItem);
                }
                cage.reset();
                player.func_184609_a(event.getHand());
            }
        }
    }
}

