/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow;

import com.whammich.sstow.ConfigHandler;
import com.whammich.sstow.JsonConfigHandler;
import com.whammich.sstow.api.ShardHelper;
import com.whammich.sstow.commands.CommandSSTOW;
import com.whammich.sstow.item.ItemSoulShard;
import com.whammich.sstow.proxy.CommonProxy;
import com.whammich.sstow.registry.ModCompatibility;
import com.whammich.sstow.registry.ModEnchantments;
import com.whammich.sstow.registry.ModItems;
import com.whammich.sstow.registry.ModRecipes;
import com.whammich.sstow.shade.lib.LendingLibrary;
import com.whammich.sstow.shade.lib.iface.ICompatibility;
import com.whammich.sstow.shade.lib.util.helper.ItemHelper;
import com.whammich.sstow.shade.lib.util.helper.LogHelper;
import com.whammich.sstow.util.EntityMapper;
import com.whammich.sstow.util.IMCHandler;
import com.whammich.sstow.util.TierHandler;
import com.whammich.sstow.util.Utils;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;

@Mod(modid="soulshardstow", name="Soul Shards - The Old Ways", version="1.10.2-2.6.7-48", acceptedMinecraftVersions="[1.10,1.11)", dependencies="required-after:Forge@[12.16.0.1840,);", updateJSON="https://gist.githubusercontent.com/TehNut/e8db2be209d32d1ebbc3/raw/VersionChecker-SSTOW.json", guiFactory="com.whammich.sstow.client.gui.GuiFactory")
public class SoulShardsTOW {
    public static final String MODID = "soulshardstow";
    public static final String NAME = "Soul Shards - The Old Ways";
    public static final String VERSION = "1.10.2-2.6.7-48";
    public static final String DEPEND = "required-after:Forge@[12.16.0.1840,);";
    public static final String JSON_CHECKER = "https://gist.githubusercontent.com/TehNut/e8db2be209d32d1ebbc3/raw/VersionChecker-SSTOW.json";
    @Mod.Instance(value="soulshardstow")
    public static SoulShardsTOW instance;
    @SidedProxy(clientSide="com.whammich.sstow.proxy.ClientProxy", serverSide="com.whammich.sstow.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs soulShardsTab;
    private File configDir;
    private LogHelper logHelper;
    private final LendingLibrary library = new LendingLibrary("soulshardstow");

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.logHelper = new LogHelper("SoulShardsTOW");
        this.configDir = new File(event.getModConfigurationDirectory(), "sstow");
        ConfigHandler.init(new File(this.configDir, "SoulShards.cfg"));
        JsonConfigHandler.initShard(new File(this.configDir, "ShardTiers.json"));
        JsonConfigHandler.initMultiblock(new File(this.configDir, "Multiblock.json"));
        this.getLibrary().registerObjects(event);
        ModItems.init();
        ModRecipes.init();
        ModEnchantments.init();
        ModCompatibility.registerModCompat();
        ModCompatibility.loadCompat(ICompatibility.InitializationPhase.PRE_INIT);
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ModCompatibility.loadCompat(ICompatibility.InitializationPhase.INIT);
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        EntityMapper.mapEntities();
        EntityMapper.initHandlers();
        ModCompatibility.loadCompat(ICompatibility.InitializationPhase.POST_INIT);
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void onIMCRecieved(FMLInterModComms.IMCEvent event) {
        IMCHandler.handleIMC(event);
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandSSTOW());
    }

    public static void debug(String message, Object ... args) {
        if (ConfigHandler.debugLogging) {
            instance.getLogHelper().info("[DEBUG] " + message, args);
        }
    }

    public File getConfigDir() {
        return this.configDir;
    }

    public LogHelper getLogHelper() {
        return this.logHelper;
    }

    public LendingLibrary getLibrary() {
        return this.library;
    }

    static {
        soulShardsTab = new CreativeTabs("soulShards"){

            public Item func_78016_d() {
                return ItemHelper.getItem(ItemSoulShard.class);
            }

            public ItemStack func_151244_d() {
                ItemStack shard = new ItemStack(ItemHelper.getItem(ItemSoulShard.class));
                ShardHelper.setTierForShard(shard, TierHandler.tiers.size() - 1);
                Utils.setMaxedKills(shard);
                ShardHelper.setBoundEntity(shard, "Pig");
                return shard;
            }
        };
    }
}

