/*
 * Decompiled with CFR 0.152.
 */
package com.whammich.sstow;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.whammich.sstow.SoulShardsTOW;
import com.whammich.sstow.item.ItemSoulShard;
import com.whammich.sstow.shade.lib.util.BlockStack;
import com.whammich.sstow.util.PosWithStack;
import com.whammich.sstow.util.TierHandler;
import com.whammich.sstow.util.serialization.SerializerBlockPos;
import com.whammich.sstow.util.serialization.SerializerBlockStack;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.tuple.Pair;

public class JsonConfigHandler {
    public static Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().disableHtmlEscaping().registerTypeAdapter(BlockStack.class, (Object)new SerializerBlockStack()).registerTypeAdapter(BlockPos.class, (Object)new SerializerBlockPos()).create();

    public static void initShard(File jsonConfig) {
        try {
            if (!jsonConfig.exists() && jsonConfig.createNewFile()) {
                Map<Integer, TierHandler.Tier> defaultMap = JsonConfigHandler.handleShardDefaults();
                String json = gson.toJson(defaultMap, new TypeToken<Map<Integer, TierHandler.Tier>>(){}.getType());
                FileWriter writer = new FileWriter(jsonConfig);
                writer.write(json);
                writer.close();
            }
            Map tempMap = (Map)gson.fromJson((Reader)new FileReader(jsonConfig), new TypeToken<Map<Integer, TierHandler.Tier>>(){}.getType());
            for (Map.Entry tierEntry : tempMap.entrySet()) {
                TierHandler.tiers.put((Integer)tierEntry.getKey(), (TierHandler.Tier)tierEntry.getValue());
                if ((Integer)tierEntry.getKey() <= TierHandler.maxTier) continue;
                TierHandler.maxTier = (Integer)tierEntry.getKey();
            }
        }
        catch (IOException e) {
            SoulShardsTOW.instance.getLogHelper().severe("Failed to create a default Tier configuration file.", new Object[0]);
        }
    }

    public static void initMultiblock(File jsonConfig) {
        try {
            if (!jsonConfig.exists() && jsonConfig.createNewFile()) {
                ArrayList<PosWithStack> defaultList = JsonConfigHandler.handleMultiblockDefaults();
                String json = gson.toJson(defaultList, new TypeToken<ArrayList<PosWithStack>>(){}.getType());
                FileWriter fileWriter = new FileWriter(jsonConfig);
                fileWriter.write(json);
                fileWriter.close();
            }
            ArrayList tempList = (ArrayList)gson.fromJson((Reader)new FileReader(jsonConfig), new TypeToken<ArrayList<PosWithStack>>(){}.getType());
            for (PosWithStack posWithStack : tempList) {
                ItemSoulShard.multiblock.add((Pair<BlockPos, BlockStack>)Pair.of((Object)posWithStack.getPos(), (Object)posWithStack.getBlock()));
            }
            for (Pair pair : ItemSoulShard.multiblock) {
                if (!((BlockPos)pair.getLeft()).equals((Object)new BlockPos(0, 0, 0))) continue;
                ItemSoulShard.originBlock = (BlockStack)pair.getRight();
            }
            if (ItemSoulShard.originBlock == null) {
                ItemSoulShard.buildMultiblock();
                SoulShardsTOW.instance.getLogHelper().error("Could not find origin block for multiblock. Setting to default structure.", new Object[0]);
            }
        }
        catch (IOException e) {
            SoulShardsTOW.instance.getLogHelper().severe("Failed to create a default Multiblock configuration file.", new Object[0]);
        }
    }

    private static Map<Integer, TierHandler.Tier> handleShardDefaults() {
        HashMap<Integer, TierHandler.Tier> ret = new HashMap<Integer, TierHandler.Tier>();
        ret.put(0, new TierHandler.Tier(0, 63, true, false, false, 0, 0));
        ret.put(1, new TierHandler.Tier(64, 127, true, true, false, 2, 20));
        ret.put(2, new TierHandler.Tier(128, 255, true, true, false, 4, 10));
        ret.put(3, new TierHandler.Tier(256, 511, false, true, false, 4, 5));
        ret.put(4, new TierHandler.Tier(512, 1023, false, true, false, 4, 5));
        ret.put(5, new TierHandler.Tier(1024, 1024, false, false, true, 6, 2));
        return ret;
    }

    private static ArrayList<PosWithStack> handleMultiblockDefaults() {
        ArrayList<PosWithStack> ret = new ArrayList<PosWithStack>();
        ret.add(new PosWithStack(new BlockPos(0, 0, 0), new BlockStack(Blocks.field_150426_aN)));
        ret.add(new PosWithStack(new BlockPos(1, 0, 0), new BlockStack(Blocks.field_150371_ca)));
        ret.add(new PosWithStack(new BlockPos(-1, 0, 0), new BlockStack(Blocks.field_150371_ca)));
        ret.add(new PosWithStack(new BlockPos(0, 0, 1), new BlockStack(Blocks.field_150371_ca)));
        ret.add(new PosWithStack(new BlockPos(0, 0, -1), new BlockStack(Blocks.field_150371_ca)));
        ret.add(new PosWithStack(new BlockPos(1, 0, 1), new BlockStack(Blocks.field_150343_Z)));
        ret.add(new PosWithStack(new BlockPos(1, 0, -1), new BlockStack(Blocks.field_150343_Z)));
        ret.add(new PosWithStack(new BlockPos(-1, 0, 1), new BlockStack(Blocks.field_150343_Z)));
        ret.add(new PosWithStack(new BlockPos(-1, 0, -1), new BlockStack(Blocks.field_150343_Z)));
        return ret;
    }
}

