/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc;

import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowfacts.shadowmc.GUIHandler;
import net.shadowfacts.shadowmc.ShadowBlocks;
import net.shadowfacts.shadowmc.ShadowItems;
import net.shadowfacts.shadowmc.ShadowMCConfig;
import net.shadowfacts.shadowmc.ShadowRecipes;
import net.shadowfacts.shadowmc.capability.Storage;
import net.shadowfacts.shadowmc.command.CommandHandler;
import net.shadowfacts.shadowmc.config.ForgeConfigAdapter;
import net.shadowfacts.shadowmc.event.ShadowMCEventHandler;
import net.shadowfacts.shadowmc.flair.FlairManager;
import net.shadowfacts.shadowmc.oxygen.OxygenHandler;
import net.shadowfacts.shadowmc.oxygen.OxygenProvider;
import net.shadowfacts.shadowmc.oxygen.OxygenReceiver;
import net.shadowfacts.shadowmc.oxygen.impl.OxygenHandlerImpl;
import net.shadowfacts.shadowmc.oxygen.impl.OxygenProviderImpl;
import net.shadowfacts.shadowmc.oxygen.impl.OxygenReceiverImpl;
import net.shadowfacts.shadowmc.proxy.CommonProxy;
import net.shadowfacts.shadowmc.structure.creator.TESRStructureCreator;
import net.shadowfacts.shadowmc.structure.creator.TileEntityStructureCreator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="shadowmc", name="ShadowMC", version="3.6.1", acceptedMinecraftVersions="[1.10.2]", guiFactory="net.shadowfacts.shadowmc.GUIFactory")
public class ShadowMC {
    public static final String modId = "shadowmc";
    public static final String name = "ShadowMC";
    public static final String version = "3.6.1";
    public static final Logger log = LogManager.getLogger((String)"ShadowMC");
    @SidedProxy(serverSide="net.shadowfacts.shadowmc.proxy.CommonProxy", clientSide="net.shadowfacts.shadowmc.proxy.ClientProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="shadowmc")
    public static ShadowMC instance;
    public static SimpleNetworkWrapper network;
    public static ShadowItems items;
    public static ShadowBlocks blocks;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ForgeConfigAdapter.init();
        ShadowMCConfig.init(event.getModConfigurationDirectory());
        ShadowMCConfig.load();
        items.init();
        blocks.init();
        ShadowRecipes.init();
        if (event.getSide() == Side.CLIENT) {
            this.preInitClient();
        }
        proxy.preInit(event);
        this.registerCapabilities();
        MinecraftForge.EVENT_BUS.register((Object)new ShadowMCEventHandler());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GUIHandler());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        FlairManager.initCommon();
        proxy.init(event);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)CommandHandler.instance);
    }

    @SideOnly(value=Side.CLIENT)
    private void preInitClient() {
        if (ShadowMCConfig.enableStructureCreator) {
            ClientRegistry.bindTileEntitySpecialRenderer(TileEntityStructureCreator.class, (TileEntitySpecialRenderer)new TESRStructureCreator());
        }
    }

    private void registerCapabilities() {
        CapabilityManager.INSTANCE.register(OxygenHandler.class, new Storage(), OxygenHandlerImpl.class);
        CapabilityManager.INSTANCE.register(OxygenReceiver.class, new Storage(), OxygenReceiverImpl.class);
        CapabilityManager.INSTANCE.register(OxygenProvider.class, new Storage(), OxygenProviderImpl.class);
    }

    static {
        items = new ShadowItems();
        blocks = new ShadowBlocks();
    }
}

