/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.util;

import aroma1997.core.util.ItemUtil;
import aroma1997.core.util.ServerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;

public class InvUtil {
    public static FuelFilter fuelFilter = new FuelFilter();
    public static DefaultFilter defaultFilter = new DefaultFilter();

    public static ItemStack putIntoFirstSlot(IInventory inv, ItemStack item, boolean simulate) {
        return InvUtil.putIntoFirstSlot(inv, item, simulate, null);
    }

    public static ItemStack putIntoFirstSlot(IInventory inv, ItemStack item, boolean simulate, EnumFacing side) {
        ItemStack itemtmp;
        int i;
        if (item == null || item.field_77994_a <= 0) {
            return null;
        }
        if (inv == null) {
            return item;
        }
        ItemStack item1 = item.func_77946_l();
        int[] slots = InvUtil.getAccessibleSlots(inv, side);
        for (i = 0; i < slots.length; ++i) {
            itemtmp = inv.func_70301_a(slots[i]);
            if (itemtmp == null || (item1 = InvUtil.mergeItems(itemtmp, item1, simulate)) != null) continue;
            if (!simulate) {
                inv.func_70296_d();
            }
            return null;
        }
        for (i = 0; i < slots.length; ++i) {
            itemtmp = inv.func_70301_a(slots[i]);
            if (itemtmp != null || !InvUtil.canInsert(inv, item1, i, side)) continue;
            if (!simulate) {
                inv.func_70299_a(slots[i], item1);
                inv.func_70296_d();
            }
            return null;
        }
        inv.func_70296_d();
        return item1;
    }

    public static ItemStack mergeItems(ItemStack main, ItemStack merge, boolean simulate) {
        if (ItemUtil.areItemsSameMatching(main, merge, ItemUtil.IItemMatchCriteria.ID, ItemUtil.IItemMatchCriteria.DAMAGE, ItemUtil.IItemMatchCriteria.NBT)) {
            if (main.field_77994_a >= main.func_77976_d()) {
                return merge;
            }
            int diff = main.func_77976_d() - main.field_77994_a;
            if (diff >= merge.field_77994_a) {
                if (!simulate) {
                    main.field_77994_a += merge.field_77994_a;
                }
                return null;
            }
            if (simulate) {
                merge = merge.func_77946_l();
            } else {
                main.field_77994_a += diff;
            }
            merge.field_77994_a -= diff;
            return merge;
        }
        return merge;
    }

    public static void clearInventory(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack item = inv.func_70301_a(i);
            if (item == null) continue;
            inv.func_70298_a(i, item.field_77994_a);
        }
    }

    public static int[] getAccessibleSlots(IInventory inv, EnumFacing side) {
        if (inv == null) {
            return null;
        }
        if (inv instanceof ISidedInventory) {
            return ((ISidedInventory)inv).func_180463_a(side);
        }
        int[] slots = new int[inv.func_70302_i_()];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public static boolean canInsert(IInventory inv, ItemStack item, int slot, EnumFacing side) {
        if (inv == null || item == null) {
            return false;
        }
        if (inv instanceof ISidedInventory) {
            return ((ISidedInventory)inv).func_180462_a(slot, item, side);
        }
        return true;
    }

    public static boolean canExtract(IInventory inv, ItemStack item, int slot, EnumFacing side) {
        if (inv == null || item == null) {
            return false;
        }
        if (inv instanceof ISidedInventory) {
            return ((ISidedInventory)inv).func_180461_b(slot, item, side);
        }
        return true;
    }

    public static int getFirstItem(IInventory inv, Class<?> claSS) {
        return InvUtil.getFirstItem(inv, claSS, null);
    }

    public static int getFirstItem(IInventory inv, Class<?> claSS, EnumFacing side) {
        return InvUtil.getFirstItem(inv, claSS, side, defaultFilter);
    }

    public static int getFirstItem(IInventory inv, Class<?> claSS, EnumFacing side, IFilter filter) {
        int[] slots = InvUtil.getAccessibleSlots(inv, side);
        for (int i = 0; i < slots.length; ++i) {
            ItemStack item = inv.func_70301_a(slots[i]);
            if (item == null || !claSS.isInstance(item.func_77973_b()) || !filter.isOk(item)) continue;
            return slots[i];
        }
        return -1;
    }

    @Deprecated
    public static ItemStack getFirstItem(IInventory inv, ItemStack item) {
        return InvUtil.getFirstItem(inv, item, false);
    }

    public static ItemStack getFirstItem(IInventory inv, ItemStack item, boolean simulate) {
        return InvUtil.getFirstItem(inv, item, simulate, null);
    }

    public static ItemStack getFirstItem(IInventory inv, ItemStack item, boolean simulate, EnumFacing side) {
        return InvUtil.getFirstItem(inv, item, simulate, side, defaultFilter);
    }

    public static ItemStack getFirstItem(IInventory inv, ItemStack item, boolean simulate, EnumFacing side, IFilter filter) {
        int[] slots = InvUtil.getAccessibleSlots(inv, side);
        for (int i = 0; i < slots.length; ++i) {
            if (!InvUtil.canExtract(inv, item, slots[i], side) || !ItemUtil.areItemsSameMatching(item, inv.func_70301_a(slots[i]), ItemUtil.IItemMatchCriteria.ID, ItemUtil.IItemMatchCriteria.DAMAGE, ItemUtil.IItemMatchCriteria.NBT) || !filter.isOk(inv.func_70301_a(slots[i]))) continue;
            if (simulate) {
                return inv.func_70301_a(slots[i]);
            }
            return inv.func_70298_a(slots[i], Math.min(inv.func_70301_a((int)slots[i]).field_77994_a, item.field_77994_a));
        }
        return null;
    }

    public static boolean hasSpace(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) != null) continue;
            return true;
        }
        return false;
    }

    public static IInventory getInv(TileEntity te) {
        if (te instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)te;
            ArrayList<TileEntityChest> invs = new ArrayList<TileEntityChest>(5);
            invs.add(chest);
            if (chest.field_145991_k != null) {
                invs.add(chest);
            }
            if (chest.field_145990_j != null) {
                invs.add(chest);
            }
            if (chest.field_145992_i != null) {
                invs.add(chest);
            }
            if (chest.field_145988_l != null) {
                invs.add(chest);
            }
            if (invs.size() > 1) {
                return new MultiInvWrapper(invs.toArray(new IInventory[0]));
            }
            return chest;
        }
        if (te instanceof IInventory) {
            return (IInventory)te;
        }
        return null;
    }

    public static class MultiInvWrapper
    implements ISidedInventory {
        private final IInventory[] invs;

        public MultiInvWrapper(IInventory ... inventories) {
            this.invs = inventories;
        }

        private IInventory getInv(int slot) {
            for (IInventory inv : this.invs) {
                if (slot < inv.func_70302_i_()) {
                    return inv;
                }
                slot -= inv.func_70302_i_();
            }
            return this.invs[this.invs.length - 1];
        }

        private int getAdjustedSlot(int slot) {
            for (IInventory inv : this.invs) {
                if (slot < inv.func_70302_i_()) {
                    return slot;
                }
                slot -= inv.func_70302_i_();
            }
            return slot;
        }

        public int func_70302_i_() {
            int size = 0;
            for (IInventory inv : this.invs) {
                size += inv.func_70302_i_();
            }
            return size;
        }

        public ItemStack func_70301_a(int index) {
            return this.getInv(index).func_70301_a(this.getAdjustedSlot(index));
        }

        public ItemStack func_70298_a(int index, int count) {
            return this.getInv(index).func_70298_a(this.getAdjustedSlot(index), count);
        }

        public ItemStack func_70304_b(int index) {
            return this.getInv(index).func_70304_b(this.getAdjustedSlot(index));
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.getInv(index).func_70299_a(this.getAdjustedSlot(index), stack);
        }

        public int func_70297_j_() {
            return this.invs[0].func_70297_j_();
        }

        public void func_70296_d() {
            for (IInventory inv : this.invs) {
                inv.func_70296_d();
            }
        }

        public boolean func_70300_a(EntityPlayer player) {
            for (IInventory inv : this.invs) {
                if (inv.func_70300_a(player)) continue;
                return false;
            }
            return true;
        }

        public void func_174889_b(EntityPlayer player) {
            for (IInventory inv : this.invs) {
                inv.func_174889_b(player);
            }
        }

        public void func_174886_c(EntityPlayer player) {
            for (IInventory inv : this.invs) {
                inv.func_174886_c(player);
            }
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return this.getInv(index).func_94041_b(this.getAdjustedSlot(index), stack);
        }

        public int func_174887_a_(int id) {
            return 0;
        }

        public void func_174885_b(int id, int value) {
        }

        public int func_174890_g() {
            return 0;
        }

        public void func_174888_l() {
            for (IInventory inv : this.invs) {
                inv.func_174888_l();
            }
        }

        public String func_70005_c_() {
            String name = "MultiInv:[";
            for (IInventory inv : this.invs) {
                name = name + inv.func_70005_c_() + ",";
            }
            return name.substring(0, name.length() - 1) + "]";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return ServerUtil.getChatForString(this.func_70005_c_());
        }

        public int[] func_180463_a(EnumFacing side) {
            ArrayList<Integer> slots = new ArrayList<Integer>();
            int start = 0;
            for (IInventory inv : this.invs) {
                if (inv instanceof ISidedInventory) {
                    ISidedInventory isided = (ISidedInventory)inv;
                    for (int slot : isided.func_180463_a(side)) {
                        slots.add(start + slot);
                    }
                } else {
                    for (int i = 0; i < inv.func_70302_i_(); ++i) {
                        slots.add(start + i);
                    }
                }
                start += inv.func_70302_i_();
            }
            int[] ret = new int[slots.size()];
            start = 0;
            Iterator iterator = slots.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                ret[start++] = i;
            }
            return ret;
        }

        public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
            IInventory inv = this.getInv(index);
            index = this.getAdjustedSlot(index);
            if (inv instanceof ISidedInventory) {
                return ((ISidedInventory)inv).func_180462_a(index, itemStackIn, direction);
            }
            return inv.func_94041_b(index, itemStackIn);
        }

        public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
            IInventory inv = this.getInv(index);
            index = this.getAdjustedSlot(index);
            if (inv instanceof ISidedInventory) {
                return ((ISidedInventory)inv).func_180461_b(index, stack, direction);
            }
            return true;
        }
    }

    public static class DefaultFilter
    implements IFilter {
        private DefaultFilter() {
        }

        @Override
        public boolean isOk(ItemStack items) {
            return true;
        }
    }

    public static class FuelFilter
    implements IFilter {
        private FuelFilter() {
        }

        @Override
        public boolean isOk(ItemStack items) {
            return TileEntityFurnace.func_145954_b((ItemStack)items);
        }
    }

    public static interface IFilter {
        public boolean isOk(ItemStack var1);
    }
}

