/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.core.coremod.asm;

import aroma1997.core.coremod.asm.AsmUtils;
import aroma1997.core.coremod.asm.BasicTransformer;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class InterfaceInsertionTransformer
extends BasicTransformer {
    private final String iface;
    private final String redirect;
    private String selfArg;
    private boolean includeDefaults;
    private HashSet<MethodNode> methods;

    protected InterfaceInsertionTransformer(String iface, String redirect) {
        this.iface = iface.replace('.', '/');
        this.redirect = redirect.replace('.', '/');
        this.setSelfArg(AsmUtils.getDescriptorForClass(Object.class));
    }

    protected void setSelfArg(String str) {
        this.selfArg = str.replace('.', '/');
    }

    protected void overrideDefaults(boolean b) {
        this.includeDefaults = b;
    }

    @Override
    public void transform(ClassNode classNode) {
        if (this.methods == null) {
            try {
                ClassReader clazz = this.getClassReader(this.iface);
                this.methods = new HashSet();
                LinkedList<ClassReader> q = new LinkedList<ClassReader>();
                q.add(clazz);
                while (!q.isEmpty()) {
                    ClassNode current = new ClassNode();
                    ((ClassReader)q.poll()).accept((ClassVisitor)current, 0);
                    for (MethodNode m : current.methods) {
                        this.methods.add(m);
                    }
                    for (String next : current.interfaces) {
                        q.add(this.getClassReader(next));
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Loaded classes in wrong order. Thos won't work.", e);
            }
        }
        assert (!classNode.interfaces.contains(this.iface));
        classNode.interfaces.add(this.iface);
        logger.log(Level.INFO, "Adding interface " + this.iface + " to class " + classNode.name + " using redirect " + this.redirect);
        HashSet<String> methodsBuffer = new HashSet<String>();
        for (MethodNode mn : classNode.methods) {
            methodsBuffer.add(mn.name + mn.desc);
        }
        for (MethodNode m : this.methods) {
            this.addMethodToClass(m, classNode, methodsBuffer);
        }
    }

    private void addMethodToClass(MethodNode oldmn, ClassNode classNode, Set<String> methodsBuffer) {
        String total = oldmn.name + oldmn.desc;
        logger.log(Level.INFO, "Adding Method " + total + " to class " + classNode.name);
        if (methodsBuffer.contains(total)) {
            this.onDuplicateMethod(oldmn, classNode.name, total);
            return;
        }
        MethodNode mn = new MethodNode(1, oldmn.name, oldmn.desc, oldmn.signature, null);
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)new VarInsnNode(25, 0));
        int i = 0;
        for (String arg : () -> AsmUtils.splitParams(AsmUtils.extractParameters(mn.desc))) {
            list.add((AbstractInsnNode)new VarInsnNode(AsmUtils.getLoadCodeForType(arg), ++i));
        }
        list.add((AbstractInsnNode)new MethodInsnNode(184, this.redirect, mn.name, "(L" + this.selfArg + ";" + mn.desc.substring(1), false));
        list.add((AbstractInsnNode)new InsnNode(AsmUtils.getReturnCodeForType(AsmUtils.extractReturnType(mn.desc))));
        mn.instructions.insert(list);
        classNode.methods.add(mn);
    }

    protected void onDuplicateMethod(MethodNode mm, String name, String method) {
        logger.log(Level.ERROR, "Failed to add interface " + this.iface + " to class " + name + ". Duplicate method " + method);
    }

    private ClassReader getClassReader(String className) throws IOException {
        return new ClassReader(this.getClass().getClassLoader().getResourceAsStream(className.replace('.', '/') + ".class"));
    }
}

