/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.ritual;

import WayofTime.bloodmagic.api.ritual.AreaDescriptor;
import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.ritual.IMasterRitualStone;
import WayofTime.bloodmagic.api.ritual.Ritual;
import WayofTime.bloodmagic.api.ritual.RitualComponent;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class RitualPlacer
extends Ritual {
    public static final String PLACER_RANGE = "placerRange";
    public static final String CHEST_RANGE = "chest";

    public RitualPlacer() {
        super("ritualPlacer", 0, 5000, "ritual.BloodMagic.placerRitual");
        this.addBlockRange(PLACER_RANGE, new AreaDescriptor.Rectangle(new BlockPos(-2, 0, -2), 5, 1, 5));
        this.addBlockRange(CHEST_RANGE, new AreaDescriptor.Rectangle(new BlockPos(0, 1, 0), 1));
        this.setMaximumVolumeAndDistanceOfRange(PLACER_RANGE, 300, 7, 7);
        this.setMaximumVolumeAndDistanceOfRange(CHEST_RANGE, 1, 3, 3);
    }

    @Override
    public void performRitual(IMasterRitualStone masterRitualStone) {
        World world = masterRitualStone.getWorldObj();
        BlockPos masterPos = masterRitualStone.getBlockPos();
        AreaDescriptor chestRange = this.getBlockRange(CHEST_RANGE);
        TileEntity tileEntity = world.func_175625_s(chestRange.getContainedPositions(masterPos).get(0));
        int currentEssence = masterRitualStone.getOwnerNetwork().getCurrentEssence();
        if (currentEssence < this.getRefreshCost()) {
            masterRitualStone.getOwnerNetwork().causeNausea();
            return;
        }
        AreaDescriptor areaDescriptor = this.getBlockRange(PLACER_RANGE);
        if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) {
            IItemHandler itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
            if (itemHandler.getSlots() <= 0) {
                return;
            }
            block0: for (BlockPos blockPos : areaDescriptor.getContainedPositions(masterRitualStone.getBlockPos())) {
                if (!world.func_180495_p(blockPos).func_177230_c().func_176200_f((IBlockAccess)world, blockPos)) continue;
                for (int invSlot = 0; invSlot < itemHandler.getSlots(); ++invSlot) {
                    ItemStack stack = itemHandler.extractItem(invSlot, 1, true);
                    if (stack == null || !(stack.func_77973_b() instanceof ItemBlock)) continue;
                    IBlockState placeState = Block.func_149634_a((Item)itemHandler.getStackInSlot(invSlot).func_77973_b()).func_176203_a(itemHandler.getStackInSlot(invSlot).func_77952_i());
                    world.func_175656_a(blockPos, placeState);
                    itemHandler.extractItem(invSlot, 1, false);
                    tileEntity.func_70296_d();
                    masterRitualStone.getOwnerNetwork().syphon(this.getRefreshCost());
                    break block0;
                }
            }
        }
    }

    @Override
    public int getRefreshCost() {
        return 50;
    }

    @Override
    public ArrayList<RitualComponent> getComponents() {
        ArrayList<RitualComponent> components = new ArrayList<RitualComponent>();
        this.addRune(components, 3, 0, 3, EnumRuneType.EARTH);
        this.addRune(components, 3, 0, -3, EnumRuneType.EARTH);
        this.addRune(components, -3, 0, 3, EnumRuneType.EARTH);
        this.addRune(components, -3, 0, -3, EnumRuneType.EARTH);
        this.addRune(components, 3, 0, 2, EnumRuneType.WATER);
        this.addRune(components, 3, 0, -2, EnumRuneType.WATER);
        this.addRune(components, 2, 0, 3, EnumRuneType.WATER);
        this.addRune(components, 2, 0, -3, EnumRuneType.WATER);
        this.addRune(components, -2, 0, 3, EnumRuneType.WATER);
        this.addRune(components, -2, 0, -3, EnumRuneType.WATER);
        this.addRune(components, -3, 0, 2, EnumRuneType.WATER);
        this.addRune(components, -3, 0, -2, EnumRuneType.WATER);
        return components;
    }

    @Override
    public Ritual getNewCopy() {
        return new RitualPlacer();
    }
}

