/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.network;

import WayofTime.bloodmagic.tile.routing.TileFilteredRoutingNode;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ItemRouterButtonPacketProcessor
implements IMessage,
IMessageHandler<ItemRouterButtonPacketProcessor, IMessage> {
    private int buttonPress;
    private int dimension;
    private BlockPos pos;

    public ItemRouterButtonPacketProcessor() {
    }

    public ItemRouterButtonPacketProcessor(int buttonPress, BlockPos pos, World world) {
        this.buttonPress = buttonPress;
        this.pos = pos;
        this.dimension = world.field_73011_w.getDimension();
    }

    public void fromBytes(ByteBuf buffer) {
        PacketBuffer buff = new PacketBuffer(buffer);
        this.dimension = buff.readInt();
        this.pos = buff.func_179259_c();
        this.buttonPress = buff.readInt();
    }

    public void toBytes(ByteBuf buffer) {
        PacketBuffer buff = new PacketBuffer(buffer);
        buff.writeInt(this.dimension);
        buff.func_179255_a(this.pos);
        buff.writeInt(this.buttonPress);
    }

    public IMessage onMessage(ItemRouterButtonPacketProcessor message, MessageContext ctx) {
        if (ctx.side == Side.SERVER) {
            message.onMessageFromClient();
        }
        return null;
    }

    public void onMessageFromClient() {
        TileEntity tile;
        WorldServer world = DimensionManager.getWorld((int)this.dimension);
        if (world != null && (tile = world.func_175625_s(this.pos)) instanceof TileFilteredRoutingNode) {
            if (this.buttonPress >= 6) {
                if (this.buttonPress == 6) {
                    ((TileFilteredRoutingNode)tile).incrementCurrentPriotiryToMaximum(9);
                } else if (this.buttonPress == 7) {
                    ((TileFilteredRoutingNode)tile).decrementCurrentPriority();
                }
            } else {
                ((TileFilteredRoutingNode)tile).swapFilters(this.buttonPress);
            }
        }
    }
}

