/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.livingArmour.tracker;

import WayofTime.bloodmagic.api.livingArmour.LivingArmourUpgrade;
import WayofTime.bloodmagic.api.livingArmour.StatTracker;
import WayofTime.bloodmagic.livingArmour.LivingArmour;
import WayofTime.bloodmagic.livingArmour.upgrade.LivingArmourUpgradeKnockbackResist;
import WayofTime.bloodmagic.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class StatTrackerFood
extends StatTracker {
    public static Map<EntityPlayer, Integer> lastFoodEatenMap = new HashMap<EntityPlayer, Integer>();
    public static int[] foodRequired = new int[]{100, 200, 300, 500, 1000};
    public int foodEaten = 0;

    @Override
    public String getUniqueIdentifier() {
        return "BloodMagic.tracker.foodEaten";
    }

    @Override
    public void resetTracker() {
        this.foodEaten = 0;
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.foodEaten = tag.func_74762_e("BloodMagic.tracker.foodEaten");
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("BloodMagic.tracker.foodEaten", this.foodEaten);
    }

    @Override
    public boolean onTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        if (!lastFoodEatenMap.containsKey(player)) {
            lastFoodEatenMap.put(player, 20);
            return false;
        }
        int currentFood = player.func_71024_bL().func_75116_a();
        int prevFood = lastFoodEatenMap.get(player);
        lastFoodEatenMap.put(player, currentFood);
        if (currentFood > prevFood) {
            this.foodEaten += currentFood - prevFood;
            this.markDirty();
            return true;
        }
        return false;
    }

    @Override
    public void onDeactivatedTick(World world, EntityPlayer player, LivingArmour livingArmour) {
        if (lastFoodEatenMap.containsKey(player)) {
            lastFoodEatenMap.remove(player);
        }
    }

    @Override
    public List<LivingArmourUpgrade> getUpgrades() {
        ArrayList<LivingArmourUpgrade> upgradeList = new ArrayList<LivingArmourUpgrade>();
        for (int i = 0; i < foodRequired.length; ++i) {
            if (this.foodEaten < foodRequired[i]) continue;
            upgradeList.add(new LivingArmourUpgradeKnockbackResist(i));
        }
        return upgradeList;
    }

    @Override
    public double getProgress(LivingArmour livingArmour, int currentLevel) {
        return Utils.calculateStandardProgress(this.foodEaten, foodRequired, currentLevel);
    }

    @Override
    public boolean providesUpgrade(String key) {
        return key.equals("BloodMagic.upgrade.knockback");
    }

    @Override
    public void onArmourUpgradeAdded(LivingArmourUpgrade upgrade) {
        int level;
        if (upgrade instanceof LivingArmourUpgradeKnockbackResist && (level = upgrade.getUpgradeLevel()) < foodRequired.length) {
            this.foodEaten = Math.max(this.foodEaten, foodRequired[level]);
            this.markDirty();
        }
    }
}

