/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item;

import WayofTime.bloodmagic.api.ritual.EnumRuneType;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.block.BlockRitualStone;
import WayofTime.bloodmagic.client.IVariantProvider;
import WayofTime.bloodmagic.item.ItemBindableBase;
import WayofTime.bloodmagic.util.helper.TextHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ItemInscriptionTool
extends ItemBindableBase
implements IVariantProvider {
    public ItemInscriptionTool() {
        this.func_77655_b("BloodMagic.scribe.");
        this.func_77627_a(true);
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77667_c(stack) + (Object)((Object)EnumRuneType.values()[stack.func_77952_i()]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item id, CreativeTabs creativeTab, List<ItemStack> list) {
        for (int i = 1; i < EnumRuneType.values().length; ++i) {
            ItemStack stack = NBTHelper.checkNBT(new ItemStack(id, 1, i));
            stack.func_77978_p().func_74768_a("uses", 10);
            list.add(stack);
        }
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockRitualStone && !((BlockRitualStone)state.func_177230_c()).isRuneType(world, pos, this.getType(stack))) {
            stack = NBTHelper.checkNBT(stack);
            int uses = stack.func_77978_p().func_74762_e("uses");
            world.func_175656_a(pos, state.func_177226_a(((BlockRitualStone)state.func_177230_c()).getProperty(), (Comparable)((Object)this.getType(stack))));
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_77978_p().func_74768_a("uses", --uses);
                if (uses <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        stack = NBTHelper.checkNBT(stack);
        int uses = stack.func_77978_p().func_74762_e("uses");
        return 1.0 - (double)uses / 10.0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean advanced) {
        list.addAll(Arrays.asList(TextHelper.cutLongString(TextHelper.localizeEffect("tooltip.BloodMagic.inscriber.desc", new Object[0]))));
        super.func_77624_a(stack, player, list, advanced);
    }

    @Override
    public List<Pair<Integer, String>> getVariants() {
        ArrayList<Pair<Integer, String>> ret = new ArrayList<Pair<Integer, String>>();
        for (int i = 1; i < EnumRuneType.values().length; ++i) {
            ret.add((Pair<Integer, String>)new ImmutablePair((Object)i, (Object)("type=" + EnumRuneType.values()[i].name())));
        }
        return ret;
    }

    public EnumRuneType getType(ItemStack stack) {
        return EnumRuneType.values()[stack.func_77952_i()];
    }
}

