/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.item;

import WayofTime.bloodmagic.BloodMagic;
import WayofTime.bloodmagic.api.ItemStackWrapper;
import WayofTime.bloodmagic.api.event.BoundToolEvent;
import WayofTime.bloodmagic.api.iface.IActivatable;
import WayofTime.bloodmagic.api.iface.IBindable;
import WayofTime.bloodmagic.api.util.helper.NBTHelper;
import WayofTime.bloodmagic.api.util.helper.NetworkHelper;
import WayofTime.bloodmagic.api.util.helper.PlayerHelper;
import WayofTime.bloodmagic.registry.ModItems;
import WayofTime.bloodmagic.util.Utils;
import WayofTime.bloodmagic.util.helper.TextHelper;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBoundTool
extends ItemTool
implements IBindable,
IActivatable {
    protected final String tooltipBase;
    private final String name;
    public Map<ItemStack, Boolean> heldDownMap = new HashMap<ItemStack, Boolean>();
    public Map<ItemStack, Integer> heldDownCountMap = new HashMap<ItemStack, Integer>();
    public final int chargeTime = 30;

    public ItemBoundTool(String name, float damage, Set<Block> effectiveBlocks) {
        super(damage, 1.0f, ModItems.BOUND_TOOL_MATERIAL, effectiveBlocks);
        this.func_77655_b("BloodMagic.bound." + name);
        this.func_77637_a(BloodMagic.tabBloodMagic);
        this.name = name;
        this.tooltipBase = "tooltip.BloodMagic.bound." + name + ".";
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        return this.getActivated(stack) ? this.func_150913_i().func_77998_b() : 1.0f;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        subItems.add(Utils.setUnbreakable(new ItemStack(itemIn)));
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (Strings.isNullOrEmpty((String)this.getOwnerUUID(stack))) {
            this.setActivatedState(stack, false);
            return;
        }
        if (entity instanceof EntityPlayer && this.getActivated(stack) && isSelected && this.getBeingHeldDown(stack) && stack == ((EntityPlayer)entity).func_184607_cu()) {
            EntityPlayer player = (EntityPlayer)entity;
            this.setHeldDownCount(stack, Math.min(player.func_184605_cv(), 30));
        } else if (!isSelected) {
            this.setBeingHeldDown(stack, false);
        }
        if (entity instanceof EntityPlayer && this.getActivated(stack) && world.func_82737_E() % 80L == 0L) {
            NetworkHelper.getSoulNetwork(this.getOwnerUUID(stack)).syphonAndDamage((EntityPlayer)entity, 20);
        }
    }

    protected int getHeldDownCount(ItemStack stack) {
        if (!this.heldDownCountMap.containsKey(stack)) {
            return 0;
        }
        return this.heldDownCountMap.get(stack);
    }

    protected void setHeldDownCount(ItemStack stack, int count) {
        this.heldDownCountMap.put(stack, count);
    }

    protected boolean getBeingHeldDown(ItemStack stack) {
        if (!this.heldDownMap.containsKey(stack)) {
            return false;
        }
        return this.heldDownMap.get(stack);
    }

    protected void setBeingHeldDown(ItemStack stack, boolean heldDown) {
        this.heldDownMap.put(stack, heldDown);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            this.setActivatedState(stack, !this.getActivated(stack));
        }
        if (!player.func_70093_af() && this.getActivated(stack)) {
            BoundToolEvent.Charge event = new BoundToolEvent.Charge(player, stack);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)event.result);
            }
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(stack, world, player, hand);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        EntityPlayer player;
        if (entityLiving instanceof EntityPlayer && !(player = (EntityPlayer)entityLiving).func_70093_af() && this.getActivated(stack)) {
            int i = this.func_77626_a(stack) - timeLeft;
            BoundToolEvent.Release event = new BoundToolEvent.Release(player, stack, i);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            i = event.charge;
            this.onBoundRelease(stack, worldIn, player, Math.min(i, 30));
            this.setBeingHeldDown(stack, false);
        }
    }

    protected void onBoundRelease(ItemStack stack, World world, EntityPlayer player, int charge) {
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77619_b() {
        return 50;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        if (TextHelper.canTranslate(this.tooltipBase + "desc")) {
            tooltip.add(TextHelper.localizeEffect(this.tooltipBase + "desc", new Object[0]));
        }
        tooltip.add(TextHelper.localize("tooltip.BloodMagic." + (this.getActivated(stack) ? "activated" : "deactivated"), new Object[0]));
        if (!stack.func_77942_o()) {
            return;
        }
        if (!Strings.isNullOrEmpty((String)this.getOwnerUUID(stack))) {
            tooltip.add(TextHelper.localizeEffect("tooltip.BloodMagic.currentOwner", PlayerHelper.getUsernameFromStack(stack)));
        }
        super.func_77624_a(stack, player, tooltip, advanced);
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)this.name);
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        return ArrayListMultimap.create();
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getActivated(stack) && this.getBeingHeldDown(stack);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return (double)(-Math.min(this.getHeldDownCount(stack), 30)) / 30.0 + 1.0;
    }

    protected static void dropStacks(Multiset<ItemStackWrapper> drops, World world, BlockPos posToDrop) {
        for (Multiset.Entry entry : drops.entrySet()) {
            int count;
            ItemStackWrapper stack = (ItemStackWrapper)entry.getElement();
            int maxStackSize = stack.item.getItemStackLimit(stack.toStack(1));
            for (count = entry.getCount(); count >= maxStackSize; count -= maxStackSize) {
                world.func_72838_d((Entity)new EntityItem(world, (double)posToDrop.func_177958_n(), (double)posToDrop.func_177956_o(), (double)posToDrop.func_177952_p(), stack.toStack(maxStackSize)));
            }
            if (count <= 0) continue;
            world.func_72838_d((Entity)new EntityItem(world, (double)posToDrop.func_177958_n(), (double)posToDrop.func_177956_o(), (double)posToDrop.func_177952_p(), stack.toStack(count)));
        }
    }

    @Override
    public String getOwnerName(ItemStack stack) {
        return stack != null ? NBTHelper.checkNBT(stack).func_77978_p().func_74779_i("ownerNAME") : null;
    }

    @Override
    public String getOwnerUUID(ItemStack stack) {
        return stack != null ? NBTHelper.checkNBT(stack).func_77978_p().func_74779_i("ownerUUID") : null;
    }

    @Override
    public boolean onBind(EntityPlayer player, ItemStack stack) {
        return true;
    }

    @Override
    public boolean getActivated(ItemStack stack) {
        return stack != null && NBTHelper.checkNBT(stack).func_77978_p().func_74767_n("activated");
    }

    @Override
    public ItemStack setActivatedState(ItemStack stack, boolean activated) {
        if (stack != null) {
            NBTHelper.checkNBT(stack).func_77978_p().func_74757_a("activated", activated);
            return stack;
        }
        return null;
    }

    public String getTooltipBase() {
        return this.tooltipBase;
    }

    public String getName() {
        return this.name;
    }

    public Map<ItemStack, Boolean> getHeldDownMap() {
        return this.heldDownMap;
    }

    public Map<ItemStack, Integer> getHeldDownCountMap() {
        return this.heldDownCountMap;
    }

    public int getChargeTime() {
        return this.chargeTime;
    }
}

