/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render.ctx;

import java.util.EnumMap;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import team.chisel.api.render.IBlockRenderContext;
import team.chisel.client.render.ModelChiselBlock;
import team.chisel.client.render.RegionCache;
import team.chisel.client.render.ctm.CTM;

public class CTMBlockRenderContext
implements IBlockRenderContext {
    private EnumMap<EnumFacing, CTM> ctmData = new EnumMap(EnumFacing.class);
    private long data;

    public CTMBlockRenderContext(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        world = new RegionCache(pos, 1, world);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            CTM ctm = this.createCTM(state);
            ctm.createSubmapIndices(world, pos, face);
            this.ctmData.put(face, ctm);
            this.data |= ctm.serialized() << face.ordinal() * 8;
        }
    }

    public CTMBlockRenderContext(long data) {
        this.data = data;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            CTM ctm = this.createCTM(null);
            ctm.createSubmapIndices(data, face);
            this.ctmData.put(face, ctm);
        }
    }

    protected CTM createCTM(@Nonnull IBlockState state) {
        ModelChiselBlock model = (ModelChiselBlock)Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
        return CTM.getInstance().ignoreStates(model.getModel().ignoreStates());
    }

    public CTM getCTM(EnumFacing face) {
        return this.ctmData.get(face);
    }

    @Override
    public long getCompressedData() {
        return this.data;
    }
}

