/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers;

import com.jaquadro.minecraft.storagedrawers.config.CompTierRegistry;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import com.jaquadro.minecraft.storagedrawers.config.OreDictRegistry;
import com.jaquadro.minecraft.storagedrawers.config.RecipeHandlerRegistry;
import com.jaquadro.minecraft.storagedrawers.config.RenderRegistry;
import com.jaquadro.minecraft.storagedrawers.config.WailaRegistry;
import com.jaquadro.minecraft.storagedrawers.core.Api;
import com.jaquadro.minecraft.storagedrawers.core.CommonProxy;
import com.jaquadro.minecraft.storagedrawers.core.ModBlocks;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.ModRecipes;
import com.jaquadro.minecraft.storagedrawers.core.handlers.GuiHandler;
import com.jaquadro.minecraft.storagedrawers.integration.LocalIntegrationRegistry;
import com.jaquadro.minecraft.storagedrawers.network.BoolConfigUpdateMessage;
import com.jaquadro.minecraft.storagedrawers.network.CountUpdateMessage;
import com.jaquadro.minecraft.storagedrawers.security.SecurityRegistry;
import java.io.File;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="StorageDrawers", name="Storage Drawers", version="1.10.2-3.6.2", dependencies="required-after:Forge@[12.17.0.1908,);required-after:Chameleon@[2.2.0,3.0.0);after:waila;", guiFactory="com.jaquadro.minecraft.storagedrawers.core.ModGuiFactory", acceptedMinecraftVersions="[1.9,1.11)")
public class StorageDrawers {
    public static final String MOD_ID = "StorageDrawers";
    public static final String MOD_NAME = "Storage Drawers";
    public static final String MOD_VERSION = "1.10.2-3.6.2";
    public static final String SOURCE_PATH = "com.jaquadro.minecraft.storagedrawers.";
    public static final Api api = new Api();
    public static final ModBlocks blocks = new ModBlocks();
    public static final ModItems items = new ModItems();
    public static final ModRecipes recipes = new ModRecipes();
    public static SimpleNetworkWrapper network;
    public static ConfigManager config;
    public static CompTierRegistry compRegistry;
    public static OreDictRegistry oreDictRegistry;
    public static RecipeHandlerRegistry recipeHandlerRegistry;
    public static RenderRegistry renderRegistry;
    public static WailaRegistry wailaRegistry;
    public static SecurityRegistry securityRegistry;
    @Mod.Instance(value="StorageDrawers")
    public static StorageDrawers instance;
    @SidedProxy(clientSide="com.jaquadro.minecraft.storagedrawers.core.ClientProxy", serverSide="com.jaquadro.minecraft.storagedrawers.core.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new ConfigManager(new File(event.getModConfigurationDirectory(), "StorageDrawers.cfg"));
        network = NetworkRegistry.INSTANCE.newSimpleChannel(MOD_ID);
        network.registerMessage(BoolConfigUpdateMessage.Handler.class, BoolConfigUpdateMessage.class, 0, Side.SERVER);
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            network.registerMessage(CountUpdateMessage.Handler.class, CountUpdateMessage.class, 1, Side.CLIENT);
        } else {
            network.registerMessage(CountUpdateMessage.HandlerStub.class, CountUpdateMessage.class, 1, Side.CLIENT);
        }
        compRegistry = new CompTierRegistry();
        oreDictRegistry = new OreDictRegistry();
        recipeHandlerRegistry = new RecipeHandlerRegistry();
        renderRegistry = new RenderRegistry();
        wailaRegistry = new WailaRegistry();
        securityRegistry = new SecurityRegistry();
        blocks.init();
        items.init();
        proxy.initDynamic();
        proxy.initClient();
        proxy.registerRenderers();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        MinecraftForge.EVENT_BUS.register((Object)instance);
        LocalIntegrationRegistry.instance().init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        recipes.init();
        LocalIntegrationRegistry.instance().postInit();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        boolean preShiftValue = StorageDrawers.config.cache.invertShift;
        if (event.getModID().equals(MOD_ID)) {
            config.syncConfig();
        }
        if (event.isWorldRunning() && preShiftValue != StorageDrawers.config.cache.invertShift) {
            network.sendToServer((IMessage)new BoolConfigUpdateMessage(FMLClientHandler.instance().getClientPlayerEntity().func_110124_au().toString(), "invertShift", StorageDrawers.config.cache.invertShift));
        }
    }

    @SubscribeEvent
    public void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        ConfigManager.serverPlayerConfigSettings.remove(event.player.func_110124_au());
    }
}

