/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityIEProjectile
extends EntityArrow {
    protected int blockX = -1;
    protected int blockY = -1;
    protected int blockZ = -1;
    protected Block inBlock;
    protected int inMeta;
    public boolean field_70254_i;
    public int field_70252_j;
    public int field_70257_an;
    private int tickLimit = 40;
    private static final DataParameter<String> dataMarker_shooter = EntityDataManager.func_187226_a(EntityIEProjectile.class, (DataSerializer)DataSerializers.field_187194_d);

    public EntityIEProjectile(World world) {
        super(world);
        this.func_70105_a(0.125f, 0.125f);
        this.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
    }

    public EntityIEProjectile(World world, double x, double y, double z, double ax, double ay, double az) {
        super(world);
        this.func_70105_a(0.125f, 0.125f);
        this.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
        this.func_70107_b(x, y, z);
        this.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
    }

    public EntityIEProjectile(World world, EntityLivingBase living, double ax, double ay, double az) {
        super(world);
        this.func_70105_a(0.125f, 0.125f);
        this.func_70012_b(living.field_70165_t, living.field_70163_u + (double)living.func_70047_e(), living.field_70161_v, living.field_70177_z, living.field_70125_A);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        this.field_70159_w = ax;
        this.field_70181_x = ay;
        this.field_70179_y = az;
        this.field_70250_c = living;
        this.setShooterSynced();
        this.func_70186_c(this.field_70159_w, this.field_70181_x, this.field_70179_y, 3.0f, 1.0f);
        this.field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(dataMarker_shooter, (Object)"");
    }

    public void setTickLimit(int limit) {
        this.tickLimit = limit;
    }

    public void setShooterSynced() {
        this.field_70180_af.func_187227_b(dataMarker_shooter, (Object)this.field_70250_c.func_70005_c_());
    }

    public EntityLivingBase getShooterSynced() {
        String s = (String)this.field_70180_af.func_187225_a(dataMarker_shooter);
        if (s != null) {
            return this.field_70170_p.func_72924_a(s);
        }
        return null;
    }

    public Entity getShooter() {
        return this.field_70250_c;
    }

    protected ItemStack func_184550_j() {
        return null;
    }

    public void func_70071_h_() {
        AxisAlignedBB axisalignedbb;
        if (this.getShooter() == null && this.field_70170_p.field_72995_K) {
            this.field_70250_c = this.getShooterSynced();
        }
        this.func_70030_z();
        BlockPos blockpos = new BlockPos(this.blockX, this.blockY, this.blockZ);
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        if (iblockstate.func_185904_a() != Material.field_151579_a && (axisalignedbb = block.func_180646_a(iblockstate, this.field_70170_p, blockpos)) != null && axisalignedbb.func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.field_70254_i = true;
        }
        if (this.field_70254_i) {
            int j = block.func_176201_c(iblockstate);
            if (block == this.inBlock && j == this.inMeta) {
                ++this.field_70252_j;
                if (this.field_70252_j >= this.getMaxTicksInGround()) {
                    this.func_70106_y();
                }
            } else {
                this.field_70254_i = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70252_j = 0;
                this.field_70257_an = 0;
            }
        } else {
            ++this.field_70257_an;
            if (this.field_70257_an >= this.tickLimit) {
                this.func_70106_y();
                return;
            }
            Vec3d currentPos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d nextPos = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult mop = this.field_70170_p.func_147447_a(currentPos, nextPos, false, true, false);
            currentPos = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            nextPos = mop != null ? new Vec3d(mop.field_72307_f.field_72450_a, mop.field_72307_f.field_72448_b, mop.field_72307_f.field_72449_c) : new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (mop == null || mop.field_72308_g == null) {
                Entity entity = null;
                List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
                double d0 = 0.0;
                for (int i = 0; i < list.size(); ++i) {
                    double d1;
                    Entity entity1 = (Entity)list.get(i);
                    if (!entity1.func_70067_L() || entity1.func_70028_i(this.field_70250_c) && this.field_70257_an <= 5) continue;
                    float f = 0.3f;
                    AxisAlignedBB axisalignedbb2 = entity1.func_174813_aQ().func_72314_b((double)f, (double)f, (double)f);
                    RayTraceResult movingobjectposition1 = axisalignedbb2.func_72327_a(currentPos, nextPos);
                    if (movingobjectposition1 == null || !((d1 = currentPos.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                    entity = entity1;
                    d0 = d1;
                }
                if (entity != null) {
                    mop = new RayTraceResult(entity);
                }
            }
            if (mop != null) {
                if (!this.func_70027_ad() && this.canIgnite() && mop.field_72308_g != null && mop.field_72308_g.func_70027_ad()) {
                    this.func_70015_d(3);
                }
                if (mop.field_72308_g instanceof EntityLivingBase) {
                    this.onImpact(mop);
                    this.func_70106_y();
                } else if (mop.field_72313_a == RayTraceResult.Type.BLOCK) {
                    this.onImpact(mop);
                    this.blockX = mop.func_178782_a().func_177958_n();
                    this.blockY = mop.func_178782_a().func_177956_o();
                    this.blockZ = mop.func_178782_a().func_177952_p();
                    IBlockState state = this.field_70170_p.func_180495_p(mop.func_178782_a());
                    this.inBlock = state.func_177230_c();
                    this.inMeta = this.inBlock.func_176201_c(state);
                    this.field_70159_w = mop.field_72307_f.field_72450_a - this.field_70165_t;
                    this.field_70181_x = mop.field_72307_f.field_72448_b - this.field_70163_u;
                    this.field_70179_y = mop.field_72307_f.field_72449_c - this.field_70161_v;
                    float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                    this.field_70165_t -= this.field_70159_w / (double)f2 * (double)0.05f;
                    this.field_70163_u -= this.field_70181_x / (double)f2 * (double)0.05f;
                    this.field_70161_v -= this.field_70179_y / (double)f2 * (double)0.05f;
                    this.field_70254_i = true;
                    if (this.inBlock.func_149688_o(state) != Material.field_151579_a) {
                        this.inBlock.func_180634_a(this.field_70170_p, mop.func_178782_a(), state, (Entity)this);
                    }
                }
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float motion = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70125_A = (float)(Math.atan2(this.field_70181_x, motion) * 180.0 / Math.PI);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float movementDecay = this.getMotionDecayFactor();
            if (this.func_70090_H()) {
                for (int j = 0; j < 4; ++j) {
                    float f3 = 0.25f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f3, this.field_70163_u - this.field_70181_x * (double)f3, this.field_70161_v - this.field_70179_y * (double)f3, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
                movementDecay *= 0.8f;
            }
            this.field_70159_w *= (double)movementDecay;
            this.field_70181_x *= (double)movementDecay;
            this.field_70179_y *= (double)movementDecay;
            this.field_70181_x -= this.getGravity();
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
    }

    public void func_70100_b_(EntityPlayer p_70100_1_) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double p_70112_1_) {
        double d1 = this.func_174813_aQ().func_72320_b() * 4.0;
        return p_70112_1_ < (d1 *= 64.0) * d1;
    }

    public double getGravity() {
        return 0.05f;
    }

    public boolean canIgnite() {
        return false;
    }

    public int getMaxTicksInGround() {
        return 100;
    }

    public abstract void onImpact(RayTraceResult var1);

    protected float getMotionDecayFactor() {
        return 0.99f;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74777_a("xTile", (short)this.blockX);
        nbt.func_74777_a("yTile", (short)this.blockY);
        nbt.func_74777_a("zTile", (short)this.blockZ);
        nbt.func_74774_a("inTile", (byte)Block.func_149682_b((Block)this.inBlock));
        nbt.func_74774_a("inMeta", (byte)this.inMeta);
        nbt.func_74774_a("inGround", (byte)(this.field_70254_i ? 1 : 0));
        if (this.field_70250_c != null) {
            nbt.func_74778_a("shootingEntity", this.field_70250_c.func_70005_c_());
        }
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.blockX = nbt.func_74765_d("xTile");
        this.blockY = nbt.func_74765_d("yTile");
        this.blockZ = nbt.func_74765_d("zTile");
        this.inBlock = Block.func_149729_e((int)(nbt.func_74771_c("inTile") & 0xFF));
        boolean bl = this.field_70254_i = nbt.func_74771_c("inGround") == 1;
        if (this.field_70170_p != null) {
            this.field_70250_c = this.field_70170_p.func_72924_a(nbt.func_74779_i("shootingEntity"));
        }
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        return false;
    }
}

