/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.metal;

import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.IEContent;
import blusunrize.immersiveengineering.common.blocks.BlockTypes_MetalsAll;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import blusunrize.immersiveengineering.common.blocks.wooden.BlockTypes_WoodenDecoration;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntitySheetmetalTank
extends TileEntityMultiblockPart<TileEntitySheetmetalTank>
implements IEBlockInterfaces.IBlockOverlayText,
IEBlockInterfaces.IPlayerInteraction,
IEBlockInterfaces.IComparatorOverride {
    public FluidTank tank = new FluidTank(512000);
    private int[] oldComps = new int[4];
    private int masterCompOld;
    @SideOnly(value=Side.CLIENT)
    private AxisAlignedBB renderAABB;

    @Override
    public String[] getOverlayText(EntityPlayer player, RayTraceResult mop, boolean hammer) {
        if (Utils.isFluidRelatedItemStack(player.func_184586_b(EnumHand.MAIN_HAND))) {
            TileEntitySheetmetalTank master = (TileEntitySheetmetalTank)this.master();
            FluidStack fs = master != null ? master.tank.getFluid() : this.tank.getFluid();
            String s = null;
            s = fs != null ? fs.getLocalizedName() + ": " + fs.amount + "mB" : I18n.func_135052_a((String)"gui.immersiveengineering.empty", (Object[])new Object[0]);
            return new String[]{s};
        }
        return null;
    }

    @Override
    public boolean useNixieFont(EntityPlayer player, RayTraceResult mop) {
        return false;
    }

    public void func_73660_a() {
        if (this.field_174879_c == 4 && !this.field_145850_b.field_72995_K && this.field_145850_b.func_175687_A(this.func_174877_v()) > 0) {
            for (int i = 0; i < 6; ++i) {
                int accepted;
                if (i == 1 || this.tank.getFluidAmount() <= 0) continue;
                EnumFacing f = EnumFacing.func_82600_a((int)i);
                int outSize = Math.min(144, this.tank.getFluidAmount());
                FluidStack out = new FluidStack(this.tank.getFluid().getFluid(), outSize);
                BlockPos outputPos = this.func_174877_v().func_177972_a(f);
                IFluidHandler output = FluidUtil.getFluidHandler((World)this.field_145850_b, (BlockPos)outputPos, (EnumFacing)f.func_176734_d());
                if (output == null || (accepted = output.fill(out, false)) <= 0) continue;
                int drained = output.fill(Utils.copyFluidStackWithAmount(out, Math.min(out.amount, accepted), false), true);
                this.tank.drain(drained, true);
                this.markContainingBlockForUpdate(null);
                this.updateComparatorValuesPart2();
            }
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.readCustomNBT(nbt, descPacket);
        this.tank.readFromNBT(nbt.func_74775_l("tank"));
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, boolean descPacket) {
        super.writeCustomNBT(nbt, descPacket);
        NBTTagCompound tankTag = this.tank.writeToNBT(new NBTTagCompound());
        nbt.func_74782_a("tank", (NBTBase)tankTag);
    }

    @Override
    public float[] getBlockBounds() {
        if (this.field_174879_c == 9) {
            return new float[]{0.375f, 0.0f, 0.375f, 0.625f, 1.0f, 0.625f};
        }
        if (this.field_174879_c == 0 || this.field_174879_c == 2 || this.field_174879_c == 6 || this.field_174879_c == 8) {
            return new float[]{0.375f, 0.0f, 0.375f, 0.625f, 1.0f, 0.625f};
        }
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    }

    @Override
    public ItemStack getOriginalBlock() {
        return this.field_174879_c == 0 || this.field_174879_c == 2 || this.field_174879_c == 6 || this.field_174879_c == 8 ? new ItemStack((Block)IEContent.blockWoodenDecoration, 1, BlockTypes_WoodenDecoration.FENCE.getMeta()) : new ItemStack((Block)IEContent.blockSheetmetal, 1, BlockTypes_MetalsAll.IRON.getMeta());
    }

    @Override
    public void disassemble() {
        super.func_145843_s();
        if (this.formed && !this.field_145850_b.field_72995_K) {
            BlockPos startPos = this.func_174877_v().func_177982_a(-this.offset[0], -this.offset[1], -this.offset[2]);
            if (!(this.offset[0] == 0 && this.offset[1] == 0 && this.offset[2] == 0 || this.field_145850_b.func_175625_s(startPos) instanceof TileEntitySheetmetalTank)) {
                return;
            }
            for (int yy = 0; yy <= 4; ++yy) {
                for (int xx = -1; xx <= 1; ++xx) {
                    for (int zz = -1; zz <= 1; ++zz) {
                        ItemStack s = null;
                        TileEntity te = this.field_145850_b.func_175625_s(startPos.func_177982_a(xx, yy, zz));
                        if (te instanceof TileEntitySheetmetalTank) {
                            s = ((TileEntitySheetmetalTank)te).getOriginalBlock();
                            ((TileEntitySheetmetalTank)te).formed = false;
                        }
                        if (startPos.func_177982_a(xx, yy, zz).equals((Object)this.func_174877_v())) {
                            s = this.getOriginalBlock();
                        }
                        if (s == null || Block.func_149634_a((Item)s.func_77973_b()) == null) continue;
                        if (startPos.func_177982_a(xx, yy, zz).equals((Object)this.func_174877_v())) {
                            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5, s));
                            continue;
                        }
                        if (Block.func_149634_a((Item)s.func_77973_b()) == IEContent.blockMetalMultiblock) {
                            this.field_145850_b.func_175698_g(startPos.func_177982_a(xx, yy, zz));
                        }
                        this.field_145850_b.func_175656_a(startPos.func_177982_a(xx, yy, zz), Block.func_149634_a((Item)s.func_77973_b()).func_176203_a(s.func_77952_i()));
                    }
                }
            }
        }
    }

    @Override
    protected IFluidTank[] getAccessibleFluidTanks(EnumFacing side) {
        TileEntitySheetmetalTank master = (TileEntitySheetmetalTank)this.master();
        if (master != null && (this.field_174879_c == 4 || this.field_174879_c == 40)) {
            return new FluidTank[]{master.tank};
        }
        return new FluidTank[0];
    }

    @Override
    protected boolean canFillTankFrom(int iTank, EnumFacing side, FluidStack resource) {
        return this.field_174879_c == 4 || this.field_174879_c == 40;
    }

    @Override
    protected boolean canDrainTankFrom(int iTank, EnumFacing side) {
        return this.field_174879_c == 4;
    }

    @Override
    public boolean interact(EnumFacing side, EntityPlayer player, EnumHand hand, ItemStack heldItem, float hitX, float hitY, float hitZ) {
        TileEntitySheetmetalTank master = (TileEntitySheetmetalTank)this.master();
        if (master != null) {
            FluidStack f = FluidUtil.getFluidContained((ItemStack)heldItem);
            if (FluidUtil.interactWithFluidHandler((ItemStack)heldItem, (IFluidHandler)master.tank, (EntityPlayer)player)) {
                this.updateMasterBlock(null, true);
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = this.field_174879_c == 4 ? new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, 0, -1), this.func_174877_v().func_177982_a(2, 5, 2)) : new AxisAlignedBB(this.func_174877_v(), this.func_174877_v());
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return super.func_145833_n() * Config.IEConfig.increasedTileRenderdistance;
    }

    @Override
    public int getComparatorInputOverride() {
        if (this.field_174879_c == 4) {
            return 15 * this.tank.getFluidAmount() / this.tank.getCapacity();
        }
        TileEntitySheetmetalTank master = (TileEntitySheetmetalTank)this.master();
        if (this.offset[1] >= 1 && this.offset[1] <= 4 && master != null) {
            FluidTank t = master.tank;
            int layer = this.offset[1] - 1;
            int vol = t.getCapacity() / 4;
            int filled = t.getFluidAmount() - layer * vol;
            int ret = Math.min(15, Math.max(0, 15 * filled / vol));
            return ret;
        }
        return 0;
    }

    private void updateComparatorValuesPart1() {
        int vol = this.tank.getCapacity() / 4;
        for (int i = 0; i < 4; ++i) {
            int filled = this.tank.getFluidAmount() - i * vol;
            this.oldComps[i] = Math.min(15, Math.max(15 * filled / vol, 0));
        }
        this.masterCompOld = 15 * this.tank.getFluidAmount() / this.tank.getCapacity();
    }

    private void updateComparatorValuesPart2() {
        int vol = this.tank.getCapacity() / 6;
        if (15 * this.tank.getFluidAmount() / this.tank.getCapacity() != this.masterCompOld) {
            this.field_145850_b.func_175685_c(this.func_174877_v(), this.func_145838_q());
        }
        for (int i = 0; i < 4; ++i) {
            int filled = this.tank.getFluidAmount() - i * vol;
            int now = Math.min(15, Math.max(15 * filled / vol, 0));
            if (now == this.oldComps[i]) continue;
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos pos = this.func_174877_v().func_177982_a(-this.offset[0] + x, -this.offset[1] + i + 1, -this.offset[2] + z);
                    this.field_145850_b.func_175685_c(pos, this.field_145850_b.func_180495_p(pos).func_177230_c());
                }
            }
        }
    }
}

