/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.reactor;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.reactor.IFusionReactor;
import mekanism.api.reactor.IReactorBlock;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;

public abstract class TileEntityReactorBlock
extends TileEntityElectricBlock
implements IReactorBlock {
    public IFusionReactor fusionReactor;
    public boolean attempted;
    public boolean changed;

    public TileEntityReactorBlock() {
        super("ReactorBlock", 0.0);
        this.inventory = new ItemStack[0];
    }

    public TileEntityReactorBlock(String name, double maxEnergy) {
        super(name, maxEnergy);
    }

    public void setReactor(IFusionReactor reactor) {
        if (reactor != this.fusionReactor) {
            this.changed = true;
        }
        this.fusionReactor = reactor;
    }

    public IFusionReactor getReactor() {
        return this.fusionReactor;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.getReactor() != null) {
            this.getReactor().formMultiblock(false);
        }
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.changed) {
            this.changed = false;
        }
        if (!(this.field_145850_b.field_72995_K || this.ticker != 5 || this.attempted || this.getReactor() != null && this.getReactor().isFormed())) {
            this.updateController();
        }
        this.attempted = false;
    }

    public EnumSet<EnumFacing> getOutputtingSides() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    public EnumSet<EnumFacing> getConsumingSides() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (!(this instanceof TileEntityReactorController) && this.getReactor() != null) {
            this.getReactor().formMultiblock(true);
        }
    }

    public void onAdded() {
        super.onAdded();
        if (!this.field_145850_b.field_72995_K) {
            if (this.getReactor() != null) {
                this.getReactor().formMultiblock(false);
            } else {
                this.updateController();
            }
        }
    }

    public void updateController() {
        TileEntityReactorController found;
        if (!(this instanceof TileEntityReactorController || (found = new ControllerFinder().find()) == null || found.getReactor() != null && found.getReactor().isFormed())) {
            found.formMultiblock(false);
        }
    }

    public class ControllerFinder {
        public TileEntityReactorController found;
        public Set<Coord4D> iterated = new HashSet<Coord4D>();

        public void loop(Coord4D pos) {
            if (this.iterated.size() > 512 || this.found != null) {
                return;
            }
            this.iterated.add(pos);
            for (EnumFacing side : EnumFacing.field_82609_l) {
                Coord4D coord = pos.offset(side);
                if (this.iterated.contains(coord) || !(coord.getTileEntity((IBlockAccess)TileEntityReactorBlock.this.field_145850_b) instanceof TileEntityReactorBlock)) continue;
                ((TileEntityReactorBlock)coord.getTileEntity((IBlockAccess)((TileEntityReactorBlock)TileEntityReactorBlock.this).field_145850_b)).attempted = true;
                if (coord.getTileEntity((IBlockAccess)TileEntityReactorBlock.this.field_145850_b) instanceof TileEntityReactorController) {
                    this.found = (TileEntityReactorController)coord.getTileEntity((IBlockAccess)TileEntityReactorBlock.this.field_145850_b);
                    return;
                }
                this.loop(coord);
            }
        }

        public TileEntityReactorController find() {
            this.loop(Coord4D.get((TileEntity)TileEntityReactorBlock.this));
            return this.found;
        }
    }
}

