/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.item;

import cofh.api.energy.IEnergyContainerItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.MekanismConfig;
import mekanism.api.energy.IEnergizedItem;
import mekanism.client.MekKeyHandler;
import mekanism.client.MekanismKeyHandler;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.base.ISustainedTank;
import mekanism.common.integration.IC2ItemManager;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.generators.common.block.states.BlockStateGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="IC2")})
public class ItemBlockGenerator
extends ItemBlock
implements IEnergizedItem,
ISpecialElectricItem,
ISustainedInventory,
ISustainedTank,
IEnergyContainerItem,
ISecurityItem {
    public Block metaBlock;

    public ItemBlockGenerator(Block block) {
        super(block);
        this.metaBlock = block;
        this.func_77627_a(true);
    }

    public int getItemStackLimit(ItemStack stack) {
        BlockStateGenerator.GeneratorType type = BlockStateGenerator.GeneratorType.get(stack);
        if (type.maxEnergy == -1.0) {
            return 64;
        }
        return 1;
    }

    public int func_77647_b(int i) {
        return i;
    }

    public String func_77667_c(ItemStack itemstack) {
        if (BlockStateGenerator.GeneratorType.get(itemstack) == null) {
            return "KillMe!";
        }
        return this.func_77658_a() + "." + BlockStateGenerator.GeneratorType.get((ItemStack)itemstack).name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        BlockStateGenerator.GeneratorType type = BlockStateGenerator.GeneratorType.get(itemstack);
        if (type.maxEnergy > -1.0) {
            if (!MekKeyHandler.getIsKeyPressed((KeyBinding)MekanismKeyHandler.sneakKey)) {
                list.add(LangUtils.localize((String)"tooltip.hold") + " " + EnumColor.INDIGO + GameSettings.func_74298_c((int)MekanismKeyHandler.sneakKey.func_151463_i()) + EnumColor.GREY + " " + LangUtils.localize((String)"tooltip.forDetails") + ".");
                list.add(LangUtils.localize((String)"tooltip.hold") + " " + EnumColor.AQUA + GameSettings.func_74298_c((int)MekanismKeyHandler.sneakKey.func_151463_i()) + EnumColor.GREY + " " + LangUtils.localize((String)"tooltip.and") + " " + EnumColor.AQUA + GameSettings.func_74298_c((int)MekanismKeyHandler.modeSwitchKey.func_151463_i()) + EnumColor.GREY + " " + LangUtils.localize((String)"tooltip.forDesc") + ".");
            } else if (!MekKeyHandler.getIsKeyPressed((KeyBinding)MekanismKeyHandler.modeSwitchKey)) {
                if (this.hasSecurity(itemstack)) {
                    list.add(SecurityUtils.getOwnerDisplay((String)entityplayer.func_70005_c_(), (String)this.getOwner(itemstack)));
                    list.add(EnumColor.GREY + LangUtils.localize((String)"gui.security") + ": " + SecurityUtils.getSecurityDisplay((ItemStack)itemstack, (Side)Side.CLIENT));
                    if (SecurityUtils.isOverridden((ItemStack)itemstack, (Side)Side.CLIENT)) {
                        list.add(EnumColor.RED + "(" + LangUtils.localize((String)"gui.overridden") + ")");
                    }
                }
                list.add(EnumColor.BRIGHT_GREEN + LangUtils.localize((String)"tooltip.storedEnergy") + ": " + EnumColor.GREY + MekanismUtils.getEnergyDisplay((double)this.getEnergy(itemstack)));
                if (this.hasTank(itemstack) && this.getFluidStack(itemstack) != null) {
                    list.add(EnumColor.PINK + FluidRegistry.getFluidName((FluidStack)this.getFluidStack(itemstack)) + ": " + EnumColor.GREY + this.getFluidStack((Object[])new Object[]{itemstack}).amount + "mB");
                }
                list.add(EnumColor.AQUA + LangUtils.localize((String)"tooltip.inventory") + ": " + EnumColor.GREY + LangUtils.transYesNo((this.getInventory(itemstack) != null && this.getInventory(itemstack).func_74745_c() != 0 ? 1 : 0) != 0));
            } else {
                list.addAll(MekanismUtils.splitTooltip((String)type.getDescription(), (ItemStack)itemstack));
            }
        } else if (!MekKeyHandler.getIsKeyPressed((KeyBinding)MekanismKeyHandler.sneakKey)) {
            list.add(LangUtils.localize((String)"tooltip.hold") + " " + EnumColor.INDIGO + GameSettings.func_74298_c((int)MekanismKeyHandler.sneakKey.func_151463_i()) + EnumColor.GREY + " " + LangUtils.localize((String)"tooltip.forDetails") + ".");
        } else {
            list.addAll(MekanismUtils.splitTooltip((String)type.getDescription(), (ItemStack)itemstack));
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState state) {
        boolean place;
        block16: {
            place = true;
            Block block = world.func_180495_p(pos).func_177230_c();
            if (stack.func_77952_i() == BlockStateGenerator.GeneratorType.ADVANCED_SOLAR_GENERATOR.meta) {
                if (!block.func_176200_f((IBlockAccess)world, pos) || !world.func_175623_d(pos.func_177982_a(0, 1, 0))) {
                    return false;
                }
                for (int xPos = -1; xPos <= 1; ++xPos) {
                    for (int zPos = -1; zPos <= 1; ++zPos) {
                        if (world.func_175623_d(pos.func_177982_a(xPos, 2, zPos)) && pos.func_177956_o() + 2 <= 255) continue;
                        place = false;
                        break block16;
                    }
                }
            } else if (stack.func_77952_i() == BlockStateGenerator.GeneratorType.WIND_GENERATOR.meta) {
                if (!block.func_176200_f((IBlockAccess)world, pos)) {
                    return false;
                }
                for (int yPos = 1; yPos <= 4; ++yPos) {
                    if (world.func_175623_d(pos.func_177982_a(0, yPos, 0)) && pos.func_177956_o() + yPos <= 255) continue;
                    place = false;
                    break;
                }
            }
        }
        if (place && super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, state)) {
            TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_175625_s(pos);
            if (tileEntity instanceof ISecurityTile) {
                ISecurityTile security = (ISecurityTile)tileEntity;
                security.getSecurity().setOwner(this.getOwner(stack));
                if (this.hasSecurity(stack)) {
                    security.getSecurity().setMode(this.getSecurity(stack));
                }
                if (this.getOwner(stack) == null) {
                    security.getSecurity().setOwner(player.func_70005_c_());
                }
            }
            if (tileEntity instanceof TileEntityElectricBlock) {
                ((TileEntityElectricBlock)tileEntity).electricityStored = this.getEnergy(stack);
            }
            if (tileEntity instanceof ISustainedInventory) {
                ((ISustainedInventory)tileEntity).setInventory(this.getInventory(stack), new Object[0]);
            }
            if (tileEntity instanceof ISustainedData && stack.func_77978_p() != null) {
                ((ISustainedData)tileEntity).readSustainedData(stack);
            }
            if (tileEntity instanceof ISustainedTank && this.hasTank(stack) && this.getFluidStack(stack) != null) {
                ((ISustainedTank)tileEntity).setFluidStack(this.getFluidStack(stack), new Object[]{stack});
            }
            return true;
        }
        return false;
    }

    public void setInventory(NBTTagList nbtTags, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemDataUtils.setList((ItemStack)((ItemStack)data[0]), (String)"Items", (NBTTagList)nbtTags);
        }
    }

    public NBTTagList getInventory(Object ... data) {
        if (data[0] instanceof ItemStack) {
            return ItemDataUtils.getList((ItemStack)((ItemStack)data[0]), (String)"Items");
        }
        return null;
    }

    public void setFluidStack(FluidStack fluidStack, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (fluidStack == null || fluidStack.amount == 0 || fluidStack.getFluid() == null) {
                ItemDataUtils.removeData((ItemStack)itemStack, (String)"fluidTank");
            } else {
                ItemDataUtils.setCompound((ItemStack)itemStack, (String)"fluidTank", (NBTTagCompound)fluidStack.writeToNBT(new NBTTagCompound()));
            }
        }
    }

    public FluidStack getFluidStack(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (!ItemDataUtils.hasData((ItemStack)itemStack, (String)"fluidTank")) {
                return null;
            }
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)ItemDataUtils.getCompound((ItemStack)itemStack, (String)"fluidTank"));
        }
        return null;
    }

    public boolean hasTank(Object ... data) {
        return data[0] instanceof ItemStack && ((ItemStack)data[0]).func_77973_b() instanceof ISustainedTank && ((ItemStack)data[0]).func_77952_i() == 2;
    }

    public double getEnergy(ItemStack itemStack) {
        return ItemDataUtils.getDouble((ItemStack)itemStack, (String)"energyStored");
    }

    public void setEnergy(ItemStack itemStack, double amount) {
        ItemDataUtils.setDouble((ItemStack)itemStack, (String)"energyStored", (double)Math.max(Math.min(amount, this.getMaxEnergy(itemStack)), 0.0));
    }

    public double getMaxEnergy(ItemStack itemStack) {
        return BlockStateGenerator.GeneratorType.get((ItemStack)itemStack).maxEnergy;
    }

    public double getMaxTransfer(ItemStack itemStack) {
        return this.getMaxEnergy(itemStack) * 0.005;
    }

    public boolean canReceive(ItemStack itemStack) {
        return false;
    }

    public boolean canSend(ItemStack itemStack) {
        return BlockStateGenerator.GeneratorType.get((ItemStack)itemStack).maxEnergy != -1.0;
    }

    public int receiveEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canReceive(theItem)) {
            double energyNeeded = this.getMaxEnergy(theItem) - this.getEnergy(theItem);
            double toReceive = Math.min((double)energy * MekanismConfig.general.FROM_RF, energyNeeded);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) + toReceive);
            }
            return (int)Math.round(toReceive * MekanismConfig.general.TO_RF);
        }
        return 0;
    }

    public int extractEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canSend(theItem)) {
            double energyRemaining = this.getEnergy(theItem);
            double toSend = Math.min((double)energy * MekanismConfig.general.FROM_RF, energyRemaining);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) - toSend);
            }
            return (int)Math.round(toSend * MekanismConfig.general.TO_RF);
        }
        return 0;
    }

    public int getEnergyStored(ItemStack theItem) {
        return (int)(this.getEnergy(theItem) * MekanismConfig.general.TO_RF);
    }

    public int getMaxEnergyStored(ItemStack theItem) {
        return (int)(this.getMaxEnergy(theItem) * MekanismConfig.general.TO_RF);
    }

    @Optional.Method(modid="IC2")
    public IElectricItemManager getManager(ItemStack itemStack) {
        return IC2ItemManager.getManager((IEnergizedItem)this);
    }

    public String getOwner(ItemStack stack) {
        if (ItemDataUtils.hasData((ItemStack)stack, (String)"owner")) {
            return ItemDataUtils.getString((ItemStack)stack, (String)"owner");
        }
        return null;
    }

    public void setOwner(ItemStack stack, String owner) {
        if (owner == null || owner.isEmpty()) {
            ItemDataUtils.removeData((ItemStack)stack, (String)"owner");
            return;
        }
        ItemDataUtils.setString((ItemStack)stack, (String)"owner", (String)owner);
    }

    public ISecurityTile.SecurityMode getSecurity(ItemStack stack) {
        if (!MekanismConfig.general.allowProtection) {
            return ISecurityTile.SecurityMode.PUBLIC;
        }
        return ISecurityTile.SecurityMode.values()[ItemDataUtils.getInt((ItemStack)stack, (String)"security")];
    }

    public void setSecurity(ItemStack stack, ISecurityTile.SecurityMode mode) {
        ItemDataUtils.setInt((ItemStack)stack, (String)"security", (int)mode.ordinal());
    }

    public boolean hasSecurity(ItemStack stack) {
        BlockStateGenerator.GeneratorType type = BlockStateGenerator.GeneratorType.get(stack);
        return type.hasModel;
    }

    public boolean hasOwner(ItemStack stack) {
        return this.hasSecurity(stack);
    }
}

