/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.network.wrappers;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.network.PacketSyncableObject;
import com.brandon3055.brandonscore.network.wrappers.SyncableObject;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SyncableVec3I
extends SyncableObject {
    public Vec3I vec;
    private Vec3I lastTickVec;

    public SyncableVec3I(Vec3I vec, boolean syncInTile, boolean syncInContainer, boolean updateOnReceived) {
        super(syncInTile, syncInContainer, updateOnReceived);
        this.vec = vec;
        this.lastTickVec = vec;
    }

    public SyncableVec3I(Vec3I vec, boolean syncInTile, boolean syncInContainer) {
        super(syncInTile, syncInContainer);
        this.vec = vec;
        this.lastTickVec = vec;
    }

    @Override
    public void detectAndSendChanges(TileBCBase tile, EntityPlayer player, boolean forceSync) {
        if (!this.vec.equals(this.lastTickVec) || forceSync) {
            this.lastTickVec = this.vec.copy();
            tile.dirtyBlock();
            if (player == null) {
                BrandonsCore.network.sendToAllAround((IMessage)new PacketSyncableObject(tile, this.index, this.vec, this.updateOnReceived), tile.syncRange());
            } else if (player instanceof EntityPlayerMP) {
                BrandonsCore.network.sendTo((IMessage)new PacketSyncableObject(tile, this.index, this.vec, this.updateOnReceived), (EntityPlayerMP)player);
            } else {
                LogHelperBC.error("SyncableInt#detectAndSendChanges No valid destination for sync packet!");
            }
        }
    }

    @Override
    public void updateReceived(PacketSyncableObject packet) {
        if (packet.dataType == 7) {
            this.vec = packet.vec3I.copy();
        }
    }

    @Override
    public void toNBT(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)new NBTTagInt(this.vec.x));
        list.func_74742_a((NBTBase)new NBTTagInt(this.vec.y));
        list.func_74742_a((NBTBase)new NBTTagInt(this.vec.z));
        compound.func_74782_a("SyncableVec3I" + this.index, (NBTBase)list);
    }

    @Override
    public void fromNBT(NBTTagCompound compound) {
        NBTTagList list;
        if (compound.func_74764_b("SyncableVec3I" + this.index) && (list = compound.func_150295_c("SyncableVec3I" + this.index, 3)).func_74745_c() == 3) {
            this.vec.set(list.func_186858_c(0), list.func_186858_c(1), list.func_186858_c(2));
        }
    }

    public String toString() {
        return this.vec.toString();
    }
}

