/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.modularelements;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourARGB;
import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IMGuiListener;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiButton;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiButtonSolid;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiPopUpDialog;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiSlider;
import com.brandon3055.brandonscore.client.gui.modulargui.modularelements.MGuiTextField;
import com.brandon3055.brandonscore.utils.Utils;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;

public class MGuiColourPicker
extends MGuiPopUpDialog
implements IMGuiListener {
    public MGuiButton cancelButton;
    public MGuiButton selectButton;
    public MGuiTextField hexField;
    public MGuiSlider redSlider;
    public MGuiSlider greenSlider;
    public MGuiSlider blueSlider;
    public MGuiSlider alphaSlider;
    private boolean includeAlpha = true;
    public IMGuiListener listener;
    public Colour colour;

    public MGuiColourPicker(IModularGui modularGui, int xPos, int yPos, MGuiElementBase parent) {
        super(modularGui, xPos, yPos, parent);
        this.xSize = 80;
        this.ySize = 80;
        this.dragZoneSize = 3;
        if (parent instanceof IMGuiListener) {
            this.listener = (IMGuiListener)((Object)parent);
        }
    }

    @Override
    public void initElement() {
        if (!this.includeAlpha) {
            this.colour.a = (byte)-1;
        }
        this.hexField = new MGuiTextField(this.modularGui, this.xPos + 4, this.yPos + 4, this.xSize - 8, 12, this.fontRenderer).setText(Integer.toHexString(this.includeAlpha ? this.colour.argb() : this.colour.rgb())).setListener(this);
        this.addChild(this.hexField);
        this.hexField.setMaxStringLength(this.includeAlpha ? 8 : 6);
        this.hexField.setValidator(new Predicate<String>(){

            public boolean apply(@Nullable String input) {
                try {
                    Utils.parseHex(input);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
        this.redSlider = new MGuiSlider(this.modularGui, this.xPos + 4, this.hexField.yPos + 14, this.xSize - 8, 8).setListener(this).setBarSize(3.0);
        this.addChild(this.redSlider);
        this.redSlider.horizontal = true;
        this.redSlider.setPos((double)(this.colour.r & 0xFF) / 255.0);
        this.redSlider.sliderColour = -65536;
        this.greenSlider = new MGuiSlider(this.modularGui, this.xPos + 4, this.redSlider.yPos + 10, this.xSize - 8, 8).setListener(this).setBarSize(3.0);
        this.addChild(this.greenSlider);
        this.greenSlider.horizontal = true;
        this.greenSlider.setPos((double)(this.colour.g & 0xFF) / 255.0);
        this.greenSlider.sliderColour = -16711936;
        this.blueSlider = new MGuiSlider(this.modularGui, this.xPos + 4, this.greenSlider.yPos + 10, this.xSize - 8, 8).setListener(this).setBarSize(3.0);
        this.addChild(this.blueSlider);
        this.blueSlider.horizontal = true;
        this.blueSlider.setPos((double)(this.colour.b & 0xFF) / 255.0);
        this.blueSlider.sliderColour = -16776961;
        if (this.includeAlpha) {
            this.alphaSlider = new MGuiSlider(this.modularGui, this.xPos + 4, this.blueSlider.yPos + 10, this.xSize - 8, 8).setListener(this).setBarSize(3.0);
            this.addChild(this.alphaSlider);
            this.alphaSlider.horizontal = true;
            this.alphaSlider.setPos((double)(this.colour.a & 0xFF) / 255.0);
            this.alphaSlider.sliderColour = -1;
        }
        this.selectButton = new MGuiButtonSolid(this.modularGui, this.xPos + 4, this.yPos + this.ySize - 14, this.xSize / 2 - 5, 10, I18n.func_135052_a((String)"generic.ok.txt", (Object[])new Object[0])).setListener(this);
        this.addChild(this.selectButton);
        this.cancelButton = new MGuiButtonSolid(this.modularGui, this.selectButton.xPos + this.selectButton.xSize + 2, this.yPos + this.ySize - 14, this.xSize / 2 - 5, 10, I18n.func_135052_a((String)"gui.back", (Object[])new Object[0])).setListener(this);
        this.addChild(this.cancelButton);
        super.initElement();
    }

    @Override
    public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        this.drawBorderedRect(this.xPos, this.yPos, this.xSize, this.ySize, 1.0, -1, -16777216);
        this.drawBorderedRect(this.xPos + 4, this.yPos + this.ySize - 22, this.xSize - 8, 6.0, 0.5, this.includeAlpha ? this.colour.argb() : MGuiColourPicker.mixColours(-16777216, this.colour.argb()), -16777216);
        super.renderBackgroundLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public void onMGuiEvent(String eventString, MGuiElementBase eventElement) {
        if (eventElement == this.redSlider) {
            this.colour.r = (byte)(this.redSlider.getPos() * 255.0);
            this.hexField.setText(Integer.toHexString(this.includeAlpha ? this.colour.argb() : this.colour.rgb()));
        } else if (eventElement == this.greenSlider) {
            this.colour.g = (byte)(this.greenSlider.getPos() * 255.0);
            this.hexField.setText(Integer.toHexString(this.includeAlpha ? this.colour.argb() : this.colour.rgb()));
        } else if (eventElement == this.blueSlider) {
            this.colour.b = (byte)(this.blueSlider.getPos() * 255.0);
            this.hexField.setText(Integer.toHexString(this.includeAlpha ? this.colour.argb() : this.colour.rgb()));
        } else if (eventElement == this.alphaSlider) {
            this.colour.a = (byte)(this.alphaSlider.getPos() * 255.0);
            this.hexField.setText(Integer.toHexString(this.includeAlpha ? this.colour.argb() : this.colour.rgb()));
        } else if (eventElement == this.hexField) {
            try {
                int pos = this.hexField.getCursorPosition();
                this.colour.set(Utils.parseHex(this.hexField.getText()));
                this.redSlider.setPos((double)(this.colour.r & 0xFF) / 255.0);
                this.greenSlider.setPos((double)(this.colour.g & 0xFF) / 255.0);
                this.blueSlider.setPos((double)(this.colour.b & 0xFF) / 255.0);
                this.alphaSlider.setPos((double)(this.colour.a & 0xFF) / 255.0);
                if (!this.includeAlpha) {
                    this.colour.a = (byte)-1;
                }
                this.hexField.setCursorPosition(pos);
            }
            catch (Exception exception) {}
        } else if (eventElement == this.cancelButton) {
            if (this.listener != null) {
                this.listener.onMGuiEvent("COLOUR_PICK_CANCELED", this);
            }
            this.close();
        } else if (eventElement == this.selectButton) {
            if (this.listener != null) {
                this.listener.onMGuiEvent("COLOUR_PICKED", this);
            }
            this.close();
        }
    }

    public MGuiColourPicker setListener(IMGuiListener listener) {
        this.listener = listener;
        return this;
    }

    public void setColour(int colour) {
        this.colour = new ColourARGB(colour);
    }

    public void setColour(Colour colour) {
        this.colour = colour;
    }

    public Colour getColour() {
        return this.colour;
    }

    public int getColourARGB() {
        return this.colour.argb();
    }

    public MGuiColourPicker setIncludeAlpha(boolean includeAlpha) {
        this.includeAlpha = includeAlpha;
        this.ySize = 70;
        return this;
    }
}

