/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.blocks;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.api.IDataRetainerTile;
import com.brandon3055.brandonscore.network.PacketSyncableObject;
import com.brandon3055.brandonscore.network.PacketTileMessage;
import com.brandon3055.brandonscore.network.wrappers.SyncableObject;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class TileBCBase
extends TileEntity {
    protected Map<Byte, SyncableObject> syncableObjectMap = new HashMap<Byte, SyncableObject>();
    protected int objIndexCount = 0;
    protected int viewRange = -1;
    protected boolean shouldRefreshOnState = true;

    public void detectAndSendChanges() {
        this.detectAndSendChanges(false);
    }

    public void detectAndSendChanges(boolean forceSync) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (SyncableObject syncableObject : this.syncableObjectMap.values()) {
            if (!syncableObject.syncInTile) continue;
            syncableObject.detectAndSendChanges(this, null, forceSync);
        }
    }

    public void detectAndSendChangesToPlayer(boolean forceSync, EntityPlayerMP playerMP) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (SyncableObject syncableObject : this.syncableObjectMap.values()) {
            if (!syncableObject.syncInContainer) continue;
            syncableObject.detectAndSendChanges(this, (EntityPlayer)playerMP, forceSync);
        }
    }

    public void registerSyncableObject(SyncableObject object) {
        this.registerSyncableObject(object, true);
    }

    public void registerSyncableObject(SyncableObject object, boolean saveToNBT) {
        this.registerSyncableObject(object, saveToNBT, false);
    }

    public void registerSyncableObject(SyncableObject object, boolean saveToNBT, boolean saveToItem) {
        if (this.objIndexCount > 127) {
            throw new RuntimeException("TileBCBase#registerSyncableObject To many objects registered!");
        }
        this.syncableObjectMap.put((byte)this.objIndexCount, object.setIndex(this.objIndexCount));
        object.setSaveMode(saveToNBT, saveToItem);
        ++this.objIndexCount;
    }

    public void receiveSyncPacketFromServer(PacketSyncableObject packet) {
        if (this.syncableObjectMap.containsKey(packet.index)) {
            SyncableObject object = this.syncableObjectMap.get(packet.index);
            object.updateReceived(packet);
            if (object.updateOnReceived) {
                this.updateBlock();
            }
        }
    }

    public NetworkRegistry.TargetPoint syncRange() {
        if (this.viewRange == -1 && !this.field_145850_b.field_72995_K) {
            Field f = ReflectionHelper.findField(PlayerChunkMap.class, (String[])new String[]{"playerViewRadius", "field_72698_e"});
            f.setAccessible(true);
            try {
                this.viewRange = f.getInt(((WorldServer)this.field_145850_b).func_184164_w());
            }
            catch (IllegalAccessException e) {
                LogHelperBC.error("A THING BROKE!!!!!!!");
                e.printStackTrace();
            }
        } else if (this.field_145850_b.field_72995_K) {
            LogHelperBC.error("Hay! Someone is doing a bad thing!!! Check your side!!!!!!!");
        }
        return new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.viewRange * 16));
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        if (this instanceof IDataRetainerTile) {
            ((IDataRetainerTile)((Object)this)).writeRetainedData(nbttagcompound);
        }
        for (SyncableObject syncableObject : this.syncableObjectMap.values()) {
            syncableObject.toNBT(nbttagcompound);
        }
        this.writeExtraNBT(nbttagcompound);
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, nbttagcompound);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        if (this instanceof IDataRetainerTile) {
            ((IDataRetainerTile)((Object)this)).writeRetainedData(compound);
        }
        for (SyncableObject syncableObject : this.syncableObjectMap.values()) {
            if (!syncableObject.shouldSaveToNBT) continue;
            syncableObject.toNBT(compound);
        }
        this.writeExtraNBT(compound);
        return compound;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.readExtraNBT(tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        if (this instanceof IDataRetainerTile) {
            ((IDataRetainerTile)((Object)this)).readRetainedData(pkt.func_148857_g());
        }
        for (SyncableObject syncableObject : this.syncableObjectMap.values()) {
            syncableObject.fromNBT(pkt.func_148857_g());
        }
        this.readExtraNBT(pkt.func_148857_g());
    }

    public void sendPacketToServer(PacketTileMessage packet) {
        BrandonsCore.network.sendToServer((IMessage)packet);
    }

    public void sendPacketToClients(PacketTileMessage packet, NetworkRegistry.TargetPoint targetPoint) {
        BrandonsCore.network.sendToAllAround((IMessage)packet, targetPoint);
    }

    public void receivePacketFromClient(PacketTileMessage packet, EntityPlayerMP client) {
    }

    public void receivePacketFromServer(PacketTileMessage packet) {
    }

    public void updateBlock() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
    }

    public void dirtyBlock() {
        Chunk chunk = this.field_145850_b.func_175726_f(this.func_174877_v());
        chunk.func_76630_e();
    }

    public void setShouldRefreshOnBlockChange() {
        this.shouldRefreshOnState = false;
    }

    public IBlockState getState(Block expectedBlock) {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        return state.func_177230_c() == expectedBlock ? state : expectedBlock.func_176223_P();
    }

    public void writeRetainedData(NBTTagCompound dataCompound) {
        for (SyncableObject syncableObject : this.syncableObjectMap.values()) {
            if (!syncableObject.shouldSaveToItem) continue;
            syncableObject.toNBT(dataCompound);
        }
    }

    public void readRetainedData(NBTTagCompound dataCompound) {
        for (SyncableObject syncableObject : this.syncableObjectMap.values()) {
            if (!syncableObject.shouldSaveToItem) continue;
            syncableObject.fromNBT(dataCompound);
        }
    }

    public void writeExtraNBT(NBTTagCompound compound) {
    }

    public void readExtraNBT(NBTTagCompound compound) {
    }

    public final NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (this instanceof IDataRetainerTile) {
            ((IDataRetainerTile)((Object)this)).writeRetainedData(compound);
        }
        for (SyncableObject syncableObject : this.syncableObjectMap.values()) {
            if (!syncableObject.shouldSaveToNBT || syncableObject.shouldSaveToItem && this instanceof IDataRetainerTile) continue;
            syncableObject.toNBT(compound);
        }
        this.writeExtraNBT(compound);
        return compound;
    }

    public final void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (this instanceof IDataRetainerTile) {
            ((IDataRetainerTile)((Object)this)).readRetainedData(compound);
        }
        for (SyncableObject syncableObject : this.syncableObjectMap.values()) {
            if (!syncableObject.shouldSaveToNBT) continue;
            syncableObject.fromNBT(compound);
        }
        this.readExtraNBT(compound);
        this.onTileLoaded();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return this.shouldRefreshOnState ? oldState != newSate : oldState.func_177230_c() != newSate.func_177230_c();
    }

    public void onTileLoaded() {
    }
}

