/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.asm.transformers;

import net.minecraft.launchwrapper.IClassNameTransformer;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import net.minecraftforge.fml.common.asm.transformers.deobf.FMLRemappingAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class DeobfuscationTransformer
implements IClassTransformer,
IClassNameTransformer {
    private static final boolean RECALC_FRAMES = Boolean.parseBoolean(System.getProperty("FORGE_FORCE_FRAME_RECALC", "false"));
    private static final int WRITER_FLAGS = 1 | (RECALC_FRAMES ? 2 : 0);
    private static final int READER_FLAGS = RECALC_FRAMES ? 4 : 8;

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        ClassReader classReader = new ClassReader(bytes);
        ClassWriter classWriter = new ClassWriter(WRITER_FLAGS);
        FMLRemappingAdapter remapAdapter = new FMLRemappingAdapter((ClassVisitor)classWriter);
        classReader.accept((ClassVisitor)remapAdapter, READER_FLAGS);
        return classWriter.toByteArray();
    }

    public String remapClassName(String name) {
        return FMLDeobfuscatingRemapper.INSTANCE.map(name.replace('.', '/')).replace('/', '.');
    }

    public String unmapClassName(String name) {
        return FMLDeobfuscatingRemapper.INSTANCE.unmap(name.replace('.', '/')).replace('/', '.');
    }
}

