/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.brewing;

import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.oredict.OreDictionary;

public abstract class AbstractBrewingRecipe<T>
implements IBrewingRecipe {
    private final adz input;
    private final T ingredient;
    private final adz output;

    protected AbstractBrewingRecipe(adz input, T ingredient, adz output) {
        this.input = input;
        this.ingredient = ingredient;
        this.output = output;
        if (this.getInput() == null || this.getIngredient() == null || this.getOutput() == null) {
            throw new IllegalArgumentException("A brewing recipe cannot have a null parameter.");
        }
        if (this.getInput().c() != 1) {
            throw new IllegalArgumentException("Inputs must have a max size of 1 just like water bottles. Brewing Stands override the input with the output when the brewing is done, items that stack would end up getting lost.");
        }
    }

    @Override
    public boolean isInput(adz stack) {
        return OreDictionary.itemMatches(this.getInput(), stack, false);
    }

    @Override
    public adz getOutput(adz input, adz ingredient) {
        return this.isInput(input) && this.isIngredient(ingredient) ? adz.c((adz)this.getOutput()) : null;
    }

    public adz getInput() {
        return this.input;
    }

    public T getIngredient() {
        return this.ingredient;
    }

    public adz getOutput() {
        return this.output;
    }
}

